/* ***************************************************************************************
* FILE:          IDataBindingUpdater.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IDataBindingUpdater is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(IDataBindingUpdater_H)
#define IDataBindingUpdater_H

#include <CanderaPlatform/OS/CanderaTypes.h>

namespace Courier {

class IDataBindingUpdater
{
   public:
      virtual ~IDataBindingUpdater() {}

      /**
       * Updates the data bindings.
       * If force is set to false, then only updates if items are mark as modified. If force is set to true,
       * it updates the bindings regardless of any modified items.
       *
       * @return true if the bindings were updated; false otherwise
       */
      virtual bool Update(bool force) = 0;

      /**
       * Compares this IDataBindingUpdater instance with the given one.
       * @return 0 if both are equals, -1 if this IDataBindingUpdater has to be ordered before the given one and 1 otherwise.
       */
      virtual Candera::Int32 Compare(const IDataBindingUpdater& dataBindingUpdater)
      {
         return (this == &dataBindingUpdater) ? 0 : ((this < &dataBindingUpdater) ? -1 : 1);
      }
};


}

#endif
