/* ***************************************************************************************
* FILE:          ExpandableListViewModel.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ExpandableListViewModel is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(ExpandableListViewModel_H)
#define ExpandableListViewModel_H

#include "ListDataItem.h"
#include "ListDataProvider.h"
#include <Courier/Messaging/Message.h>

class ExpandableListViewModel
{
   public:
      ExpandableListViewModel(Candera::UInt32 listId, Candera::UInt32 sourceListId);

      void DefineTrigger(DataItemContext dataItemContext, DataItemContext expandedDataItemContext, Candera::UInt32 identifiedIndex, Candera::UInt32 subItemsIndex);

      bool OnMessage(const Courier::Message& msg);

   private:
      void SendUpdate();

      struct Trigger
      {
         Trigger() :
            _dataItemContext(0),
            _expandedDataItemContext(0),
            _identifiedIndex(0),
            _subItemsIndex(0)
         {
         }

         Trigger(DataItemContext dataItemContext, DataItemContext expandedDataItemContext, Candera::UInt32 identifiedIndex, Candera::UInt32 subItemsIndex) :
            _dataItemContext(dataItemContext),
            _expandedDataItemContext(expandedDataItemContext),
            _identifiedIndex(identifiedIndex),
            _subItemsIndex(subItemsIndex)
         {
         }

         DataItemContext _dataItemContext;
         DataItemContext _expandedDataItemContext;
         Candera::UInt32 _identifiedIndex;
         Candera::UInt32 _subItemsIndex;
      };

      typedef std::vector<Trigger> TriggerList;

      TriggerList _triggers;
      Candera::Int32 _expandedIndex;
      Candera::UInt32 _expandedSubItemIndex;
      DataItemContext _expandedDataItemContext;
      Candera::UInt32 _listId;
      Candera::UInt32 _sourceListId;
      tSharedPtrDataProvider _sourceList;
};


#endif
