/* ***************************************************************************************
* FILE:          ExpandableListViewModel.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ExpandableListViewModel is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "BaseContract/generated/BaseTouchSessionMsgs.h"
#include "Widgets/generated/WidgetsGenericMessages.h"

#include "ExpandableListViewModel.h"


ExpandableListViewModel::ExpandableListViewModel(Candera::UInt32 listId, Candera::UInt32 sourceListId) :
   _listId(listId),
   _sourceListId(sourceListId),
   _expandedIndex(-1),
   _expandedSubItemIndex(0),
   _expandedDataItemContext(0)
{
}


void ExpandableListViewModel::DefineTrigger(DataItemContext dataItemContext, DataItemContext aExpandedDataItemContext, Candera::UInt32 identifiedIndex, Candera::UInt32 subItemsIndex)
{
   DataItemContext expandedDataItemContext = ((0 == aExpandedDataItemContext) || (Candera::StringPlatform::CompareStrings(dataItemContext, aExpandedDataItemContext) == 0)) ? 0 : aExpandedDataItemContext;
   _triggers.push_back(Trigger(dataItemContext, expandedDataItemContext, identifiedIndex, subItemsIndex));
}


bool ExpandableListViewModel::OnMessage(const Courier::Message& msg)
{
   // bool msgConsumed = BaseWidget2D::OnMessage(msg); fr83hi
   if (msg.GetId() == hmibase::input::TouchSessionStartEvent::ID || msg.GetId() == hmibase::input::TouchSessionStopEvent::ID)
   {
      //       printf("Touch EV Start,Stop\n");
   }
   switch (msg.GetId())
   {
      case ButtonReactionMsg::ID:
      {
         if (!_sourceList.PointsToNull())
         {
            const ButtonReactionMsg* buttonReactionMsg = Courier::message_cast<const ButtonReactionMsg*>(&msg);
            if (buttonReactionMsg->GetEnReaction() == enRelease)
            {
               for (Courier::Int32 i = 0; i < Courier::Int32(_sourceList->windowElementSize()); ++i)
               {
                  for (size_t j = 0; j < _triggers.size(); ++j)
                  {
                     if (Candera::StringPlatform::CompareStrings(_triggers[j]._dataItemContext, (*_sourceList)[i]->dataItemContext()) == 0)
                     {
                        if ((*_sourceList)[i]->size() > _triggers[j]._identifiedIndex)
                        {
                           Candera::String identifierName = *(*(*_sourceList)[i])[_triggers[j]._identifiedIndex];
                           if (buttonReactionMsg->GetSender() == Courier::Identifier(identifierName.GetCString()))
                           {
                              _expandedIndex = (_expandedIndex == i) ? -1 : i;
                              _expandedSubItemIndex = _triggers[j]._subItemsIndex;
                              _expandedDataItemContext = _triggers[j]._expandedDataItemContext;
                              SendUpdate();
                              return true;
                           }
                        }
                     }
                  }
               }
            }
         }
      }
      break;
      case ListDateProviderReqMsg::ID:
      {
         const ListDateProviderReqMsg* listDataRequestMsg = Courier::message_cast<const ListDateProviderReqMsg*>(&msg);
         if (_listId == listDataRequestMsg->GetListId())
         {
            ListDateProviderReqMsg* msg = COURIER_MESSAGE_NEW(ListDateProviderReqMsg)(_sourceListId, listDataRequestMsg->GetStartIndex(), listDataRequestMsg->GetWindowElementSize(), listDataRequestMsg->GetCircular(), listDataRequestMsg->GetCachedData());
            if (0 != msg)
            {
               static_cast<void>(msg->Post());
            }
            return true;
         }
      }
      break;
      case ListDateProviderResMsg::ID:
      {
         const ListDateProviderResMsg* listDateProviderResMsg = Courier::message_cast<const ListDateProviderResMsg*>(&msg);
         if ((!listDateProviderResMsg->GetListDateProvider().PointsToNull()) && (_sourceListId == listDateProviderResMsg->GetListDateProvider()->listId()))
         {
            _sourceList = listDateProviderResMsg->GetListDateProvider();
            SendUpdate();
            return true;
         }
      }
      break;
      default:
         break;
   }
   return false;
}


void ExpandableListViewModel::SendUpdate()
{
   if (!_sourceList.PointsToNull())
   {
      Candera::UInt32 expandSize = 0;
      if ((_expandedIndex >= 0) && (_sourceList->windowElementSize() > Candera::UInt32(_expandedIndex)) && (*_sourceList)[_expandedIndex]->isVector())
      {
         expandSize = (*(*_sourceList)[_expandedIndex])[_expandedSubItemIndex]->size();
      }
      tSharedPtrDataProvider dataProvider = ListDataProvider::newBackEndInterface(_listId, _sourceList->startIndex(), _sourceList->windowElementSize() + expandSize, _sourceList->virtualListSize() + expandSize);
      if (expandSize > 0)
      {
         for (size_t i = 0; i < Candera::UInt32(_expandedIndex); ++i)
         {
            (*dataProvider)[i] = (*_sourceList)[i];
         }
         if (0 == _expandedDataItemContext)
         {
            (*dataProvider)[_expandedIndex] = (*_sourceList)[_expandedIndex];
         }
         else
         {
            (*dataProvider)[_expandedIndex] = (*_sourceList)[_expandedIndex]->cloneAs(_expandedDataItemContext);
         }
         tSharedPtrIDataItem rawDataItem = (*(*_sourceList)[_expandedIndex])[_expandedSubItemIndex];
         for (size_t j = 0; j < rawDataItem->size(); ++j)
         {
            (*dataProvider)[_expandedIndex + 1 + j] = tSharedPtrListDataItem(Candera::Dynamic_Cast<ListDataItem*>((*rawDataItem)[j].GetPointerToSharedInstance()));
         }
         for (size_t k = _expandedIndex + 1; k < _sourceList->windowElementSize(); ++k)
         {
            (*dataProvider)[k + expandSize] = (*_sourceList)[k];
         }
      }
      else
      {
         for (size_t i = 0; i < _sourceList->windowElementSize(); ++i)
         {
            (*dataProvider)[i] = (*_sourceList)[i];
         }
      }
      ListDateProviderResMsg* msg = COURIER_MESSAGE_NEW(ListDateProviderResMsg)(dataProvider);
      if (0 != msg)
      {
         static_cast<void>(msg->Post());
      }
   }
}
