/* ***************************************************************************************
* FILE:          AppListDataProviderCache.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AppListDataProviderCache.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(_ListProviderCache_H_)
#define _ListProviderCache_H_

#include "Widgets/2D/List/Data/ListDataProviderCache.h"
#include "View/CGI/CgiExtensions/MessageHandler.h"

namespace hmibase {
namespace widget {
class AppListDataProviderCache : public ListDataProviderCache, public ::hmibase::view::MessageHandler
{
   private:
      AppListDataProviderCache();
      virtual ~AppListDataProviderCache();
      AppListDataProviderCache(const AppListDataProviderCache&);
      AppListDataProviderCache& operator=(const AppListDataProviderCache&);
      typedef ::Courier::Internal::SingleLinkedList<Courier::MessageReferrer> tMsgRefList;
      ::Courier::Platform::CriticalSection  _critical;
      tMsgRefList                         _msgList;
   private:
      bool remove(unsigned long listID);
   public:
      static AppListDataProviderCache& getInstance();

      void setWidgetHandler();
      bool cacheList(unsigned long listID, const Courier::Message& message);
      bool checkForCachedData(unsigned long listID, Courier::MessageReferrer& msgRef);
      virtual bool onMessage(const Courier::Message& msg);
};


}
}


#endif
