/* ***************************************************************************************
* FILE:          ListWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(CustomListEnums_h)
#define CustomListEnums_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/MetaInfo/BaseInternalMacros.h>
#include <Candera/System/MetaInfo/EnumDataTypeInternal.h>
#include <Courier/DataBinding/StdTypeConverter.h>

// =========================================================================
enum ListMovementStatusType {
    ListMovementFinished,
    ListMovementItem,
    ListMovementPage,
    ListMovementSet,
    ListMovementScrolling,
    ListMovementSwiping,
    ListMovementSnap,
    ListMovementUnknown = ListMovementSnap
};
// =========================================================================


#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
    template<> ::FeatStd::UInt32 StringBufferAppender< ::ListMovementStatusType >::Append(::FeatStd::StringBuffer& stringBuffer, ::ListMovementStatusType const & object);
} //namespace FeatStd
#endif
 


#endif // ListEnums_h
