/* ***************************************************************************************
* FILE:          CoverflowListWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CoverflowListWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef Coverflow_List_Widget_2D_H
#define Coverflow_List_Widget_2D_H

#include <Widgets/2D/List/ListWidget2D.h>

#ifndef COURIER_VERSION_MAJOR
#error COURIER_VERSION_MAJOR not defined
#endif

class CoverflowListWidget2D : public ListWidget2D
{
   public:

      CGI_WIDGET_RTTI_DECLARATION(CoverflowListWidget2D, ListWidget2D);

      CoverflowListWidget2D();
      virtual ~CoverflowListWidget2D();

      void OnParentViewActivate(bool enable) override;

      virtual bool IsNumberOfItemsVisible() const;
      virtual bool AreScrollbarPropertiesVisible() const;
      virtual bool AreCoverflowPropertiesVisible() const;
      virtual bool AreFixedPageScrollingPropertiesVisible() const;
      virtual bool AreAcceptImmediatePositioningPropertiesVisible() const;
      virtual bool AreSwipingPropertiesVisible() const;
      virtual bool AreLimitExceededAnimationPropertiesVisible() const;
      virtual bool IsScrollAnimationInputVisible() const;
      virtual bool AreListAlignmentPropertiesVisible() const;

      CdaWidget2DDef(CoverflowListWidget2D, ListWidget2D)
      CdaDescription("Particular implementation of the ListWidget2D, specialized for coverflow.")
      CdaReadableName("CoverflowListWidget2D")
      CdaCategory("List")

      CdaProperties() //Start of properties
      CdaPropertiesEnd() // End of properties

      CdaWidgetDefEnd()

   protected:
};


#endif
