/* ***************************************************************************************
* FILE:          CoverflowListWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CoverflowListWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "CoverflowListWidget2D.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LIST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/CoverflowListWidget2D.cpp.trc.h"
#endif


CGI_WIDGET_RTTI_DEFINITION(CoverflowListWidget2D);

using namespace Candera;
using namespace Courier;


CoverflowListWidget2D::CoverflowListWidget2D()
{
   SetCoverflow(true);
   SetScrollingType(Candera::CircularScrolling);
   SetScrollAnimationInput(Candera::ScrollAnimationInput::IndexBased);
}


CoverflowListWidget2D::~CoverflowListWidget2D()
{
}


void CoverflowListWidget2D::OnParentViewActivate(bool enable)
{
   Base::OnParentViewActivate(enable);

   if (enable)
   {
      ListWidget2DBase::TemplateScrollAnimationType scrollAnimations(GetScrollAnimations());
      if (scrollAnimations.GetCount() == 1)
      {
         Candera::Animation::AnimationPlayer::SharedPointer& animation(scrollAnimations.Get(0));

         const Animation::AnimationController::SharedPointer controller(animation->GetController());
         if (!controller.PointsToNull())
         {
            MemoryManagement::SharedPointer<Animation::AnimationBlendedProperty> prop(controller->GetProperty(0));
            if (!prop.PointsToNull())
            {
               MemoryManagement::SharedPointer<Animation::AnimationKeyframeSequence> keyframeSequence(prop->GetKeyframeSequence(0));
               if (!keyframeSequence.PointsToNull())
               {
                  const Int32& keyframeCount(keyframeSequence->GetKeyframeCount());
                  SetNumberOfItems(keyframeCount - 2);
               }
            }
         }
      }
   }
}


bool CoverflowListWidget2D::IsNumberOfItemsVisible() const
{
   return false;
}


bool CoverflowListWidget2D::AreScrollbarPropertiesVisible() const
{
   return true;
}


bool CoverflowListWidget2D::AreCoverflowPropertiesVisible() const
{
   return false;
}


bool CoverflowListWidget2D::AreFixedPageScrollingPropertiesVisible() const
{
   return false;
}


bool CoverflowListWidget2D::AreAcceptImmediatePositioningPropertiesVisible() const
{
   return false;
}


bool CoverflowListWidget2D::AreSwipingPropertiesVisible() const
{
   return true;
}


bool CoverflowListWidget2D::AreLimitExceededAnimationPropertiesVisible() const
{
   return false;
}


bool CoverflowListWidget2D::IsScrollAnimationInputVisible() const
{
   return false;
}


bool CoverflowListWidget2D::AreListAlignmentPropertiesVisible() const
{
   return false;
}
