/* ***************************************************************************************
* FILE:          PageInfoCollectorWrapper.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PageInfoCollectorWrapper is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(PageInfoCollectorWrapper_H)
#define PageInfoCollectorWrapper_H

#include <Widgets/2D/List/Content/ListPagesInfo.h>
#include <Widgets/2D/List/Content/ITemplateRetriever.h>
#include <Widgets/2D/List/Content/AddChecker.h>
#include <Widgets/2D/List/Content/Adders/ItemAdder.h>
#include <Widgets/2D/List/Content/TemplateRetriever.h>

class PageInfoCollectorWrapper
{
   public:
      PageInfoCollectorWrapper(const ItemAdder::SharedPointer& adder);

      void CollectPagesInfo(const ContentProvider& contentProvider,
                            const AddChecker& addChecker,
                            const ITemplateRetriever& templateRetriever,
                            bool fixedPages,
                            bool firstUpdateAfterNewData,
                            FeatStd::Int32 indexOfFirstCompletelyVisibleElement,
                            FeatStd::Int32 numberOfCompleteVisibleItems,
                            bool circular,
                            const Candera::Vector2 visibleArea);

      const PagesInfo& GetPagesInfo() const;

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(PageInfoCollectorWrapper);

      ListPagesInfo _pagesInfo;
      ListPagesInfo _fixedPagesInfo;
      const ItemAdder::SharedPointer _adder;

      void CollectPageInfo(ListPagesInfo& pagesInfo,
                           const FeatStd::Int32 visibleStartInd,
                           const AddChecker& addChecker,
                           const ContentProvider& contentProvider,
                           const ITemplateRetriever& templateRetriever,
                           FeatStd::Int32 numberOfCompleteVisibleItems,
                           bool circular,
                           const Candera::Vector2 visibleArea);
};


#endif
