/* ***************************************************************************************
* FILE:          MaxIndexManager.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  MaxIndexManager is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef MaxPosition_Manger_H
#define MaxPosition_Manger_H

#include <FeatStd/Platform/Types.h>

class MaxIndexManager
{
   public:
      class MaxIndexData
      {
         public:
            MaxIndexData(const bool invalidItemsAdded,
                         const bool coverflow,
                         const bool pixelwiseEnabled,
                         const bool endReached,
                         const bool lastItemCompletelyVisible,
                         const bool firstItemCompletelyVisible,
                         const FeatStd::Int32 numberOfItemsInFirstStructure,
                         const FeatStd::Float startIndex,
                         const FeatStd::UInt32 previousVisibleItems,
                         const FeatStd::UInt32 currentVisibleItems,
                         const FeatStd::Int32 totalNumberOfElements,
                         const FeatStd::Float firstItemVisibleSize,
                         const FeatStd::Float lastItemInvisibleSize,
                         const FeatStd::Int32 configuredNumberOfItems);

            const bool _invalidItemsAdded;
            const bool _coverflow;
            const bool _pixelwiseEnabled;
            const bool _endReached;
            const bool _lastItemCompletelyVisible;
            const bool _firstItemCompletelyVisible;
            const FeatStd::Int32 _numberOfItemsInFirstStructure;
            const FeatStd::Float _startIndex;
            const FeatStd::UInt32 _previousVisibleItems;
            const FeatStd::UInt32 _currentVisibleItems;
            const FeatStd::Int32 _totalNumberOfElements;
            const FeatStd::Float _firstItemVisibleSize;
            const FeatStd::Float _lastItemInvisibleSize;
            const FeatStd::Int32 _configuredNumberOfItems;

         private:
            FEATSTD_MAKE_CLASS_UNCOPYABLE(MaxIndexData);
      };

      MaxIndexManager();

      /**
       * resets the maximum position to size - 1
       */
      void ResetMaxPosition(FeatStd::Int32 size, bool force = false);

      /**
       * updates the maximum position according to the given data
       */
      void UpdateMaxIndex(const MaxIndexData& maxPosData);

      FeatStd::Float GetMaxIndex() const;

      bool GetAccurateMaxPosition() const;

      void SetFixedPages(bool val);

      void SetIndexOfLastFixedPage(FeatStd::Int32 val);

      void SetCircular(bool val);

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(MaxIndexManager);

      FeatStd::Float _maxPosition;
      bool _accurateMaxPosition;
      bool _freshReset;
      bool _fixedPage;
      bool _circular;
      FeatStd::Int32 _indexOfLastFixedPage;
};


#endif
