/* ***************************************************************************************
* FILE:          ListContentAdder.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListContentAdder is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(ListContentAdder_H)
#define ListContentAdder_H

#include "FlexPixelWiseAnimationManager.h"
#include "Widgets/2D/List/Layouting/FlexListLayouter.h"
#include "Widgets/2D/List/Content/Adders/ItemAdder.h"
#include "MaxIndexManager.h"
#include "Widgets/2D/Common/PagesInfo.h"
#include "Widgets/2D/List/Content/ListPagesInfo.h"
#include "ListContentUpdater.h"
#include "Widgets/2D/List/Content/Adders/PositionsCache.h"
#include "Widgets/2D/List/Content/ITemplateSpanAnalyzer.h"
#include "Widgets/2D/List/Content/ISizeContainer.h"
#include "Widgets/2D/List/Content/GridOccupation.h"
#include <Widgets/2D/List/Swiping/PositioningHandler.h>
#include <Widgets/2D/List/Swiping/SwipingStateChecker.h>
#include <Widgets/2D/List/Animations/ExpandTriggerManager.h>
#include "Widgets/2D/List/Content/Adders/AddingStrategy.h"
#include <Widgets/2D/ControlTemplate/ClonedItemCachingBehavior.h>
#include <Widgets/2D/ControlTemplate/ItemLayouter.h>
#include <Widgets/2D/List/Swiping/Normalizer.h>
#include <Widgets/2D/Common/OwnerInfoRetriever.h>
#include <Widgets/2D/List/Animations/ItemSpeedAnimationManager.h>


class SwipingListContentUpdaterListener;
class ListContentAdder
{
   public:
      struct ListContentInfo
      {
         Candera::Node2D* itemsGroup;
         bool isGrid;
         bool isCoverflow;
         bool isFixedPages;
         bool isCircular;
         FeatStd::UInt32 configuredNumberOfItems;
         FeatStd::Float positionLimit;
         ItemLayouter* itemLayouter;
         ListWidget2DBase::ScrollAnimationInputType scrollAnimationInput;
      };

      enum AddingDirection
      {
         Forward = 0,
         Reverse,
         ForwardAndReverse
      };

      ListContentAdder(OrientationOperator& directOrientationOperator,
                       OrientationOperator& orthogonalOrientationOperator,
                       ControlTemplateInstanceContainer& itemsInstanceContainer,
                       const ITemplateRetriever& templateRetriever,
                       const ContentProvider& contentProvider,
                       const ItemSpeedAnimationManager& itemSpeedAnimationManager,
                       AddingDirection addingDirection);

      void Set(const ItemAdder::SharedPointer& listItemAdder,
               const AddingStrategy::SharedPointer& addingStrategy,
               MaxIndexManager* maxIndexManager,
               SwipingListContentUpdaterListener* listener,
               ExpandTriggerManager* expandTriggerManager);

      virtual ~ListContentAdder();

      /**
      *  Adds content to the list.
      * @return the index of the first added item
      */
      FeatStd::Int32 AddContent(FeatStd::Float position, Candera::Vector2 listArea, const ListContentInfo& listInfo, bool pixelwise);

      FeatStd::UInt32 GetIndexOfFirstCompletelyVisibleElement() const;

      /**
       * @return the index of the first added element, even if it's not completely visible
       */
      FeatStd::Int32 GetFirstItemIndex() const;

      /**
      * @return the index of the last added element, even if it's not completely visible
      */
      FeatStd::Int32 GetLastItemIndex() const;

      FeatStd::Float GetReversedPositionCorrection() const
      {
         return _reversePositionCorrection;
      }
      bool GetInvalidItemsAdded() const
      {
         return _invalidItemsAdded;
      }
      bool EndReached() const
      {
         return _endReached;
      }
      bool CorrectCurrentPosition() const
      {
         return _correctCurrentPosition;
      }

   protected:

   private:
      /**
       * returns true if circular scrolling is configured and needed; false otherwise. For example, if circular scrolling is configured,
       * but all the available items fit inside the viewport, circular scrolling is not needed
       */
      bool IsCircularNeeded() const;

      FeatStd::Int32 ForwardAdd(FeatStd::UInt32 firstItemIdx, FeatStd::Float position);
      FeatStd::Int32 ReverseAdd(FeatStd::UInt32 firstItemIdx, FeatStd::Float indexStartPosition);

      Candera::Node2D* AddItem(FeatStd::UInt32 index, Candera::Float position, bool& vacantVisibleArea, bool& invalidTemplate);
      Candera::Node2D* AddPixelWiseItem(Candera::Float position, FeatStd::UInt32 index, bool& vacantVisibleArea, bool& invalidTemplate);
      Candera::Node2D* ReverseAddPixelWiseItem(Candera::Float position, FeatStd::UInt32 index, bool& vacantVisibleArea, bool& invalidTemplate);

      /**
      * Extract node and template node from content provider.
      * It also set the node layouter.
      */
      bool ExtractItemNode(const FeatStd::Int32 index, Candera::Node2D*& node);

      bool GetItemSize(const FeatStd::Int32 itemIndex, FeatStd::Float& size);

      // Called before a templateInstance is added to an ItemAdder, to run template animations
      void OnPreItemAdd(ControlTemplateInstance* templateInstance, FeatStd::Float indexPosition, Candera::Float itemPosition);

      void ResetMembers();

      OrientationOperator& _orientationOperator;
      OrientationOperator& _orthogonalOrientationOperator;
      ControlTemplateInstanceContainer& _itemsInstanceContainer;
      const ContentProvider& _contentProvider;
      const ITemplateRetriever& _templateRetriever;
      ListContentInfo _listContentInfo;
      ItemAdder::SharedPointer _listItemAdder;
      AddingStrategy::SharedPointer _addingStrategy;
      MaxIndexManager* _maxIndexManager;
      SwipingListContentUpdaterListener* _listener;
      ExpandTriggerManager* _expandTriggerManager;
      Candera::Vector2 _listArea;
      AddingDirection _addingDirection;
      bool _pixelwise;
      FeatStd::UInt32 _numberOfCompleteVisibleItems;
      FeatStd::Int32 _oldVirtualListSize;
      bool _elementsShownOnlyOnce;
      FeatStd::Float _reversePositionCorrection;
      bool _invalidItemsAdded;
      bool _endReached;
      bool _correctCurrentPosition;
      const ItemSpeedAnimationManager& _itemSpeedAnimationManager;
};


#endif
