/* ***************************************************************************************
* FILE:          ITemplateRetriever.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ITemplateRetriever is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(ITemplateRetriever_H)
#define ITemplateRetriever_H

#include <Candera/Engine2D/Core/Node2D.h>
#include <Widgets/2D/List/Data/ListDataItem.h>
#include <Widgets/2D/List/generated/ListWidget2DBase.h>

class ITemplateVIsitor
{
   public:
      virtual ~ITemplateVIsitor() { }

      virtual void Visit(Candera::Node2D& t) = 0;
};


class ITemplateRetriever
{
   public:
      virtual ~ITemplateRetriever() { }
      virtual Candera::Node2D* GetTemplate(const tSharedPtrListDataItem& item) const = 0;
      virtual ListWidget2DBase::TemplateScrollAnimationType GetTemplateScrollAnimations() const = 0;
      virtual bool IsValid() const = 0;
      virtual bool IsInvalidTemplate(Candera::Node2D* templateNode) const = 0;

      /*
       * Calls the visit method of the given visitor for each template
       */
      virtual void Accept(ITemplateVIsitor* visitor) const = 0;
};


#endif
