/* ***************************************************************************************
* FILE:          GridTemplateSpanAnalyzer.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GridTemplateSpanAnalyzer is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(GridTemplateSpanAnalyzer_H)
#define GridTemplateSpanAnalyzer_H

#include <Widgets/2D/List/Content/ISizeContainer.h>
#include <Widgets/2D/List/Content/ITemplateSpanAnalyzer.h>
#include <map>

class GridTemplateSpanAnalyzer : public ITemplateSpanAnalyzer, private ITemplateVIsitor
{
   public:
      FEATSTD_TYPEDEF_SHARED_POINTER(GridTemplateSpanAnalyzer);

      static SharedPointer Create(ISizeContainer& sizesContainer);

      virtual ~GridTemplateSpanAnalyzer();

      virtual void Analyze(const ITemplateRetriever& templateRetriever) override;
      virtual Candera::Vector2 GetSpan(const Candera::Node2D* t) const override;
      virtual Candera::Vector2 GetSpanUnitSize() const override;
      virtual Candera::Vector2 GetMaxSpan() const override;
   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(GridTemplateSpanAnalyzer);

      GridTemplateSpanAnalyzer(ISizeContainer& sizesContainer);

      typedef std::map<const Candera::Node2D*, Candera::Vector2> SizeCache;

      Candera::Vector2 _minSize;
      SizeCache _templatesCache;
      ISizeContainer& _sizesContainer;
      Candera::Vector2 _maxSpan;

      void ProcessingStarted();
      void ProcessTemplate(Candera::Node2D& t);
      void ProcessingEnded();

      virtual void Visit(Candera::Node2D& t) override;
};


#endif
