/* ***************************************************************************************
* FILE:          ListContentUpdater.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListContentUpdater is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef List_Content_Content_Provider_H
#define List_Content_Content_Provider_H

#include "Widgets/2D/List/Data/ListDataWrapper.h"
#include "Widgets/2D/List/Data/ListDataItem.h"

class ContentProvider
{
   public:
      ContentProvider();
      ~ContentProvider();

      void SetData(const ListDataWrapper* listData);
      void SetItems(const tSharedPtrListDataItem& items);

      bool HasItems() const;
      tSharedPtrListDataItem GetItem(FeatStd::Int32 index) const;

      FeatStd::Int32 GetStartIndex() const;
      FeatStd::Int32 GetWindowElementSize() const;
      FeatStd::Int32 GetVirtualListSize() const;

      FeatStd::UInt32 GetListId() const;
      FeatStd::SizeType GetSequenceNumber() const;

   private:
      const ListDataWrapper* _listData;
      tSharedPtrListDataItem _items;
};


#endif
