/* ***************************************************************************************
* FILE:          StackItemAdder.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  StackItemAdder is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(StackItemAdder_H)
#define StackItemAdder_H

#include "ItemAdder.h"

/**
* @brief The class StackItemAdder is derived from ItemAdder and knows how to add an item inside a list which has the Layouter set as Stack
*/
class StackItemAdder : public ItemAdder
{
      FEATSTD_TYPEDEF_BASE(ItemAdder);

   public:
      FEATSTD_TYPEDEF_SHARED_POINTER(StackItemAdder);

      CANDERA_RTTI_DECLARATION(StackItemAdder);

      static SharedPointer Create(ISizeContainer& sizesContainer, Candera::Node2D* groupNode, const OrientationOperator& directOrientationOperator, const OrientationOperator& orthogonalOrientationOperator, const bool& coverflow);

      virtual ~StackItemAdder();

      virtual bool AddItem(Candera::Node2D& templateNode, Candera::Node2D& childNode);

      virtual void Clear();

      virtual Candera::UInt32 GetScrollingIncrement() const;

      virtual Candera::Int32 GetNumberOfItemsInFirstStructure() const;

      virtual Candera::Int32 GetNumberOfStructures() const;

   protected:
      StackItemAdder(ISizeContainer& sizesContainer, Candera::Node2D* groupNode, const OrientationOperator& directOrientationOperator, const OrientationOperator& orthogonalOrientationOperator, const bool& coverflow);

   private:
      bool _isFirstItemFound;          ///< Flag to store whether or not the first item has been found already (do not find it twice)
      const bool& _isCoverflow;

      void PreAdd(Candera::Node2D& childNode, const FeatStd::Float itemSize);
      void Add(Candera::Node2D& childNode);
      void PostAdd(Candera::Node2D& childNode, const FeatStd::Float itemSize);

      virtual void OnFinishDirectAdding() override;
      virtual void OnFinishReverseAdding() override;
      virtual void OnFinishAdding() override;
};


#endif
