/* ***************************************************************************************
* FILE:          AddingStrategy.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AddingStrategy is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "StackAddingStrategy.h"
#include "StackItemAdder.h"
#include "DefaultPositionsCalculator.h"

StackAddingStrategy::SharedPointer StackAddingStrategy::Create(ISizeContainer& sizesContainer, const OrientationOperator& directOrientationOperator, const OrientationOperator& orthogonalOrientationOperator, const bool& coverflow)
{
   return StackAddingStrategy::SharedPointer(FEATSTD_NEW(StackAddingStrategy)(sizesContainer, directOrientationOperator, orthogonalOrientationOperator, coverflow));
}


ItemAdder::SharedPointer StackAddingStrategy::CreateItemAdderImpl(Candera::Node2D* groupNode)
{
   return StackItemAdder::Create(_sizesContainer, groupNode, _directOrientationOperator, _orthogonalOrientationOperator, _coverflow);
}


void StackAddingStrategy::CollectPagesInfoImpl(const ContentProvider& contentProvider, const AddChecker& addChecker, const ITemplateRetriever& templateRetriever, bool fixedPages, bool firstUpdateAfterNewData, FeatStd::Int32 indexOfFirstCompletelyVisibleElement, FeatStd::Int32 numberOfCompleteVisibleItems, bool circular, const Candera::Vector2 visibleArea)
{
   _infoCollector.CollectPagesInfo(contentProvider, addChecker, templateRetriever, fixedPages, firstUpdateAfterNewData, indexOfFirstCompletelyVisibleElement, numberOfCompleteVisibleItems, circular, visibleArea);
}


const PagesInfo& StackAddingStrategy::GetPagesInfoImpl() const
{
   return _infoCollector.GetPagesInfo();
}


StackAddingStrategy::StackAddingStrategy(ISizeContainer& sizesContainer, const OrientationOperator& directOrientationOperator, const OrientationOperator& orthogonalOrientationOperator, const bool& coverflow) :
   Base(sizesContainer, directOrientationOperator, orthogonalOrientationOperator),
   _coverflow(coverflow),
   _infoCollector(CreateItemAdder(0))
{
}


const PositionsCalculator& StackAddingStrategy::GetPositionsCalculator() const
{
   return _calculator;
}
