/* ***************************************************************************************
* FILE:          PositionsCalculator.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PositionsCalculator is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(PositionsCalculator_H)
#define PositionsCalculator_H

#include <FeatStd/MemoryManagement/SharedPointer.h>
#include <Candera/Engine2D/Core/Node2D.h>
#include <Widgets/2D/List/Content/ContentProvider.h>
#include <Widgets/2D/List/Content/ITemplateRetriever.h>

class PositionsCalculator
{
   public:
      virtual ~PositionsCalculator() { }

      virtual FeatStd::Float CalculateStartingPosition(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::UInt32 startIndex) const = 0;

      virtual FeatStd::Int32 CalculateStartIndex(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::Float position) const = 0;
};


#endif
