/* ***************************************************************************************
* FILE:          PositionsCache.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PositionsCache is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef PositionsCache_H
#define PositionsCache_H

#include <FeatStd/Container/Vector.h>

class PositionsCache
{
   public:
      class CacheData
      {
         public:
            /**
             * @param structureIndex - the index of the structure(column index or row index)
             * @param firstIndex - the index of the first element of the structure
             */
            CacheData(const FeatStd::Int32& structureIndex, const FeatStd::Int32& firstIndex);

            FeatStd::Int32 GetStructureIndex() const
            {
               return _structureIndex;
            }
            FeatStd::Int32 GetFirstIndex() const
            {
               return _firstIndex;
            }

         private:
            FeatStd::Int32 _structureIndex;
            FeatStd::Int32 _firstIndex;
      };

      PositionsCache(FeatStd::UInt32 cacheSize = 10);

      /**
       * Finds the cached data by a requested start index.
       * @ return the cached data having the firstIndex member the greatest possible, but lower
                  than @param requestedStartIndex
       */
      CacheData FindByStartIndex(const FeatStd::Int32& requestedStartIndex) const;

      /**
      * Finds the cached data by a requested structure index.
      * @ return the cached data having the structureIndex member the greatest possible, but lower
                 than @param requestedStructureIndex
      */
      CacheData FindByStructureIndex(const FeatStd::Int32& requestedStructureIndex) const;

      /**
       * Caches the given data.
       */
      void Cache(const CacheData& data);

      void Clear();

      void UpdateCachStep(FeatStd::Int32 maxStartIndex);

   private:
      typedef FeatStd::Internal::Vector<CacheData> Positions;

      Positions _cache;
      FeatStd::Int32 _cacheStep;

      template<typename Comparer>
      CacheData Find(const CacheData& key) const;

      /**
       * Makes sure the cache is sorted.
       */
      void EnsureSorting();
};


#endif
