/* ***************************************************************************************
* FILE:          OrthoGridPositionsCalculator.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  OrthoGridPositionsCalculator is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(OrthoGridPositionsCalculator_H)
#define OrthoGridPositionsCalculator_H

#include "PositionsCalculator.h"
#include "Widgets/2D/List/Content/Adders/OrthoGridPageInfoCollection.h"


class OrthoGridPositionsCalculator : public PositionsCalculator
{
      FEATSTD_TYPEDEF_BASE(PositionsCalculator);
   public:
      OrthoGridPositionsCalculator(const OrthoGridPageInfoCollection& gridOccupation);
      virtual ~OrthoGridPositionsCalculator();

      virtual FeatStd::Float CalculateStartingPosition(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::UInt32 startIndex) const override;

      virtual FeatStd::Int32 CalculateStartIndex(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::Float position) const override;

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(OrthoGridPositionsCalculator);

      const OrthoGridPageInfoCollection& _pagesInfo;
};


#endif
