/* ***************************************************************************************
* FILE:          OrthoOrthoGridPositionsCalculator.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  OrthoGridPositionsCalculator is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#include "OrthoGridPositionsCalculator.h"

using namespace FeatStd;

OrthoGridPositionsCalculator::OrthoGridPositionsCalculator(const OrthoGridPageInfoCollection& pagesInfo) :
   _pagesInfo(pagesInfo)
{
}


OrthoGridPositionsCalculator::~OrthoGridPositionsCalculator()
{
}


FeatStd::Float OrthoGridPositionsCalculator::CalculateStartingPosition(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::UInt32 startIndex) const
{
   Float startingPos(0.0F);

   const OrthoGridPageInfo& page(_pagesInfo.GetPageByItemIndex(startIndex));
   if (!page.IsEmpty())
   {
      startingPos = page.GetStructureIndex(startIndex);
   }
   return startingPos;
}


FeatStd::Int32 OrthoGridPositionsCalculator::CalculateStartIndex(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::Float position) const
{
   Int32 startIndex(0);
   const OrthoGridPageInfo& page(_pagesInfo.GetPageByStructIndex(position));
   if (!page.IsEmpty())
   {
      startIndex = page.GetStartIndex(position);
   }
   return startIndex;
}
