/* ***************************************************************************************
* FILE:          OrthoGridPageInfoCollection.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  OrthoGridPageInfoCollection is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(OrthoGridPageInfoCollection_H)
#define OrthoGridPageInfoCollection_H

#include "OrthoGridPageInfo.h"
#include "Widgets/2D/Common/PagesInfo.h"

class OrthoGridPageInfoCollection : public PagesInfo
{
   public:
      OrthoGridPageInfoCollection();

      void AddPage(const OrthoGridPageInfo& pageInfo);

      const OrthoGridPageInfo& GetPageByStructIndex(FeatStd::Int32 structIndex) const;
      const OrthoGridPageInfo& GetPageByItemIndex(FeatStd::Int32 itemIndex) const;

      const FeatStd::Int32 GetMaxStructStartIndex() const;

      virtual bool RetrieveStartIndexOfPage(const FeatStd::Int32 pageIndex, FeatStd::Int32& startIndex) const override;
      virtual FeatStd::Int32 GetStartIndexOfLastPage() const override;

      void MarkCurrentPage(const FeatStd::Int32 structIndex);

      void AdjustMinCellSize(FeatStd::Float& val);

      void Clear();
   private:
      typedef Courier::Vector<OrthoGridPageInfo> PagesCollection;

      PagesCollection _pages;
      FeatStd::SizeType _currentPageIndex;
      FeatStd::Float _minCellSize;
};


#endif
