/* ***************************************************************************************
* FILE:          OrthoGridPageInfo.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  OrthoGridPageInfo is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(OrthoGridPageInfo_H)
#define OrthoGridPageInfo_H

#include "FeatStd/Platform/Types.h"
#include "Courier/Util/Vector.h"

class OrthoGridPageInfo
{
   public:
      OrthoGridPageInfo();

      void SetStartItemIndex(FeatStd::Int32 val);
      void SetEndItemIndex(FeatStd::Int32 val);

      void SetStructureIndices(FeatStd::Int32 begining, FeatStd::Int32 ending);

      void RetainItemLayout(FeatStd::Int32 beginingDirectStruct, FeatStd::Int32 beginingOrthoStruct, FeatStd::Int32 directSpan, FeatStd::Int32 orthoSpan, FeatStd::Int32 itemIndex);

      bool ContainsItemIndex(FeatStd::Int32 itemIndex) const;
      bool ContainsStructIndex(FeatStd::Int32 structIndex) const;

      FeatStd::Int32 GetStructureIndex(FeatStd::Int32 itemIndex) const;
      FeatStd::Int32 GetStartIndex(FeatStd::Int32 structIndex) const;

      FeatStd::Int32 GetStartStructIndex() const;
      FeatStd::Int32 GetEndStructIndex() const;

      FeatStd::Int32 GetStartItemIndex() const;
      FeatStd::Int32 GetEndItemIndex() const;

      bool IsEmpty() const;

   private:
      FeatStd::Int32 _startStructIndex;
      FeatStd::Int32 _endStructIndex;
      FeatStd::Int32 _startItemIndex;
      FeatStd::Int32 _endItemIndex;

      typedef Courier::Vector<FeatStd::Int32> IndicesCollection;
      typedef Courier::Vector<IndicesCollection> StructuresInfoCollention;

      StructuresInfoCollention _structuresInfo;
};


#endif
