/* ***************************************************************************************
* FILE:          OrthoGridItemAdder.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  OrthoGridItemAdder is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(OrthoGridItemAdder_H)
#define OrthoGridItemAdder_H

#include "ItemAdder.h"
#include <Courier/Util/Vector.h>
#include <Widgets/2D/List/Content/GridOccupation.h>
#include "PositionsCache.h"
#include "Widgets/2D/Common/PagesInfo.h"
#include "OrthoGridPageInfoCollection.h"
#include "SpanInfo.h"
#include "OrthoGridEmptyCellsPolicy.h"

class OrthoGridItemAdderListener
{
   public:
      virtual ~OrthoGridItemAdderListener() { }

      virtual void OnItemAdded() = 0;
};


/**
* @brief The class OrthoGridItemAdder is an abstract class, derived from the ItemAdder which contains the common functionality used by a list with Grid Layouter
*/
class OrthoGridItemAdder : public ItemAdder
{
      FEATSTD_TYPEDEF_BASE(ItemAdder);
   public:
      FEATSTD_TYPEDEF_SHARED_POINTER(OrthoGridItemAdder);

      CANDERA_RTTI_DECLARATION(OrthoGridItemAdder);

      static OrthoGridItemAdder::SharedPointer Create(const ITemplateSpanAnalyzer::SharedPointer& templateSpanAnalyzer, ISizeContainer& sizesContainer, Candera::Node2D* groupNode, OrthoGridPageInfoCollection& pagesInfo, const OrientationOperator& directOrientationOperator, const OrientationOperator& orthogonalOrientationOperator, Candera::UInt32 rows, Candera::UInt32 columns);

      virtual ~OrthoGridItemAdder();

      virtual bool AddItem(Candera::Node2D& templateNode, Candera::Node2D& childNode);

      virtual void Clear();

      virtual Candera::Int32 GetNumberOfItemsInFirstStructure() const;

      virtual Candera::Int32 GetNumberOfStructures() const;

      virtual Candera::Int16 GetBeginingMargin() const;

      Candera::Int32 GetCurrentIndex() const;

      /**
       * @return true if the last added item is the first in its structure; false otherwise
       */
      bool IsFirstInStructure() const;

      Candera::UInt32 GetOrthogonalItems() const;

      void SetGridOccupation(GridOccupation* val);

      virtual Candera::UInt32 GetScrollingIncrement() const;

      void SetListener(OrthoGridItemAdderListener* listener);

      void SetEmptyCellsPolicy(const OrthoGridEmptyCellsPolicy::SharedPointer& val)
      {
         _emptyCellsPolicy = val;
      }

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(OrthoGridItemAdder);

      OrthoGridItemAdder(const ITemplateSpanAnalyzer::SharedPointer& templateSpanAnalyzer, ISizeContainer& sizesContainer, Candera::Node2D* groupNode, OrthoGridPageInfoCollection& pagesInfo, const OrientationOperator& directOrientationOperator, const OrientationOperator& orthogonalOrientationOperator, Candera::UInt32 rows, Candera::UInt32 columns);

      FeatStd::Int32 _computedRows;
      FeatStd::Int32 _computedColumns;
      FeatStd::Int32 _rows;
      FeatStd::Int32 _columns;
      FeatStd::Int16 _completeBeginingMargin;
      FeatStd::Int32 _itemsInStructure;
      FeatStd::Int32 _absoluteStructureIndex; // index starting with 0
      FeatStd::Int32 _logicalStructureIndex;  // index relative to the first visible structure; invisible structures have negative indices

      FeatStd::Int32 _maxOrthogonalItemsCount;
      FeatStd::Float _currentStructureSize;
      FeatStd::Float _visibleSize;
      FeatStd::Float _unwrappedItemsSize;
      FeatStd::Float _maxItemCellSize;
      //Courier::Vector<Candera::Node2D*> _currentItems;
      typedef Courier::Vector<FeatStd::Float> SizesCollection;
      typedef Courier::Vector<SizesCollection> SizesBidimensionalCollections;
      SizesBidimensionalCollections _sizes;
      FeatStd::Float _currentMinCellSize;
      FeatStd::Int32 _itemsInFirstStructure;
      bool _firstInStructure;
      FeatStd::Int32 _currentOrthogonalIndex;

      GridOccupation* _gridOccupation;
      GridOccupation _currentOccupation;
      ITemplateSpanAnalyzer::SharedPointer _templateSpanAnalyzer;
      OrthoGridPageInfoCollection& _pagesInfo;
      OrthoGridPageInfo _page0;
      OrthoGridPageInfo _page1;
      OrthoGridEmptyCellsPolicy::SharedPointer _emptyCellsPolicy;
      Candera::Node2D* _firstItem;

      void ProcessStructureEnd();
      void CalculateCells();

      void EndCalculateCells(FeatStd::Int8& maxRelPos);

      FeatStd::Int32 PreparePages(FeatStd::Int32 numberOfCells);

      void PrepareCalculateCells();

      void AdjustSpans(const FeatStd::Int32 deltaSpan, Courier::Vector<FeatStd::Int8>& spans, const Courier::Vector<SpanInfo>& orderedSpans);

      Candera::Float GetItemOrthogonalSize(Candera::Node2D& childNode);

      Candera::UInt32 GetItemsCount() const;
      Candera::UInt32 GetOrthogonalItemsCount() const;

      void EndStructure();

      void PreAdd(Candera::Node2D& childNode, const FeatStd::Float itemSize);
      void Add(Candera::Node2D& childNode, const FeatStd::Float itemSize);
      void PostAdd(const FeatStd::Float itemSize);

      virtual Candera::Float GetPositionCorrection(const FeatStd::Float position) const;

      virtual void OnBeforeBeginAdding() override;
      virtual void OnBeginAdding() override;
      virtual void OnBeginReverseAdding() override;
      virtual void OnFinishAdding() override;
      virtual void OnFinishReverseAdding() override;

      void ShiftGridIndex(Candera::Node2D& node, FeatStd::UInt8 val) const;
      FeatStd::UInt8 GetShiftValue(const Candera::Node2D& node) const;
      FeatStd::UInt8 GetMaxShiftValue();
};


#endif
