/* ***************************************************************************************
* FILE:          OrthoOrthoGridAddingStrategy.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  OrthoGridAddingStrategy is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(OrthoGridAddingStrategy_H)
#define OrthoGridAddingStrategy_H

#include "FeatStd/MemoryManagement/SharedPointer.h"
#include "ItemAdder.h"
#include "PositionsCalculator.h"
#include "AddingStrategy.h"
#include "OrthoGridItemAdder.h"
#include "OrthoGridPositionsCalculator.h"
#include "PositionsCache.h"
#include "Widgets/2D/List/Content/Adders/GridLayoutingAdjuster.h"

class OrthoGridAddingStrategy : public AddingStrategy
{
      FEATSTD_TYPEDEF_BASE(AddingStrategy);

   public:
      FEATSTD_TYPEDEF_SHARED_POINTER(OrthoGridAddingStrategy);

      static OrthoGridAddingStrategy::SharedPointer Create(ISizeContainer& sizesContainer, const OrientationOperator& directOrientationOperator, const OrientationOperator& orthogonalOrientationOperator, const FeatStd::UInt8 rows, const FeatStd::UInt8 columns);

      void SetDynamicGridEmptyCellsPolicy(DynamicGridEmptyCellsPolicyType::Enum val);

      virtual bool SupportsViewportPadding()
      {
         return false;
      }

   private:
      OrthoGridAddingStrategy(ISizeContainer& sizesContainer, const OrientationOperator& directOrientationOperator, const OrientationOperator& orthogonalOrientationOperator, const FeatStd::UInt8 rows, const FeatStd::UInt8 columns);

      ITemplateSpanAnalyzer::SharedPointer _templateSpanAnalyzer;
      GridOccupation _gridOccupation;
      const FeatStd::UInt8 _rows;
      const FeatStd::UInt8 _columns;
      PositionsCache _positionsCache;
      OrthoGridPositionsCalculator _positionsCalculator;
      OrthoGridPageInfoCollection _pagesInfo;
      DynamicGridEmptyCellsPolicyType::Enum _dynamicGridEmptyCellsPolicy;
      GridLayoutingAdjuster _layoutingAdjuster;

      virtual const PositionsCalculator& GetPositionsCalculator() const override;
      virtual void CacheImpl(const ContentProvider& contentProvider, const ITemplateRetriever& templateRetriever) override;
      virtual ItemAdder::SharedPointer CreateItemAdderImpl(Candera::Node2D* groupNode) override;
      virtual void ProcessDataCHangedImpl(FeatStd::Int32 dataSize) override;
      virtual void AnalyzeTemplatesImpl(const ITemplateRetriever& templateRetriever) override;

      virtual FeatStd::Int32 CalculateStartIndexImpl(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::Float position) override;
      virtual FeatStd::Float AdjustMaxPositionImpl(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::UInt32 maxIndex) override;

      OrthoGridItemAdder::SharedPointer CreateOrthoGridItemAdder(Candera::Node2D* groupNode);

      virtual const PagesInfo& GetPagesInfoImpl() const override;
      OrthoGridEmptyCellsPolicy::SharedPointer CreateEmptyCellsPolicy() const;
};


#endif
