/* ***************************************************************************************
* FILE:          OrientationOperator.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  OrientationOperator is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef Orientation_Operator_H
#define Orientation_Operator_H

#include <Widgets/2D/Common/FlexScrollable.h>
#include <Candera/Engine2D/Core/Node2D.h>
#include <Widgets/2D/Common/MetaInfoEnums.h>

#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
#include <Candera/EngineBase/Layout/GridLayouter.h>
#else
#include <Candera/Engine2D/Layout/GridLayouter.h>
#endif

/**
 * @brief The class OrientationOperator contains functions to be used along with Candera::Vector2D, Candera::Margin or Candera::Node2D,
 * depending of the desired orientation(horizontal or vertical)
 */
class OrientationOperator
{
   public:
      OrientationOperator(Candera::ListScrollingOrientation orientation, bool margins);

      void SetMargin(Candera::Node2D& node, Candera::Int16 marginValue, Candera::Int16 marginValueOrthogonal, bool isFirstItem, bool isLastItem) const;
      FeatStd::Float GetVectorComponent(const Candera::Vector2& v) const;
      void SetVectorComponent(Candera::Vector2& v, FeatStd::Float val) const;
      void SetAlignment(Candera::Node2D& node, Candera::ListAlignment::Enum alignment);

      /**
       * returns the row for vertical, or the column for horizontal
       */
      FeatStd::UInt8 GetRowOrColumn(const Candera::Node2D& node) const;

      /**
       * sets the row for vertical, or the column for horizontal
       */
      void SetRowOrColumn(Candera::Node2D& node, FeatStd::UInt8 val) const;

      /**
       * sets the row span for vertical, or the column span for horizontal
       */
      void SetRowOrColumnSpan(Candera::Node2D& node, FeatStd::UInt8 val) const;

      /**
       * sets the row height for vertical, or the column width for horizontal
       */
      void SetStructureSize(Candera::GridLayouter* layouter, FeatStd::Int8 index, FeatStd::Float val) const;

      template <typename T>
      T GetValue(const T& x, const T& y) const
      {
         return _orientation == Candera::Horizontal ? x : y;
      }

   private:
      typedef void(*MarginSetter)(Candera::Node2D& node, Candera::Int16 marginValue, Candera::Int16 marginValueOrthogonal, bool isFirstItem, bool isLastItem);
      typedef FeatStd::Float(*SizeGetter)(const Candera::Vector2& v);
      typedef void (*SizeSetter)(Candera::Vector2& v, FeatStd::Float val);
      typedef void(*AlignmentSetter)(Candera::Node2D&, Candera::ListAlignment::Enum);
      typedef FeatStd::UInt8(*RowOrColumnGetter)(const Candera::Node2D& node);
      typedef void (*RowOrColumnSetter)(Candera::Node2D& node, FeatStd::UInt8 val);
      typedef void(*RowOrColumnSpanSetter)(Candera::Node2D& node, FeatStd::UInt8 val);
      typedef void(*StructureSizeSetter)(Candera::GridLayouter* layouter, FeatStd::Int8 index, FeatStd::Float val);

      Candera::ListScrollingOrientation _orientation;
      MarginSetter _marginSetter;
      SizeGetter _itemSizeGetter;
      SizeSetter _sizeSetter;
      AlignmentSetter _alignmentSetter;
      RowOrColumnGetter _rowOrColumnGetter;
      RowOrColumnSetter _rowOrColumnSetter;
      RowOrColumnSpanSetter _rowOrColumnSpanSetter;
      StructureSizeSetter _structureSIzeSetter;
};


#endif
