/* ***************************************************************************************
* FILE:          DefaultPositionsCalculator.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DefaultPositionsCalculator is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "GridLayoutingAdjuster.h"
#include "Candera/Engine2D/Core/Node2D.h"
#include "Widgets/2D/List/Layouting/FlexListLayouter.h"

using namespace Candera;
using namespace FeatStd;

GridLayoutingAdjuster::GridLayoutingAdjuster()
{
}


GridLayoutingAdjuster::~GridLayoutingAdjuster()
{
}


void GridLayoutingAdjuster::Adjust(Node2D* node, FeatStd::Int32 value, const OrientationOperator& orientationOperator)
{
   if (0 != node)
   {
      FlexListLayouter* layouter = dynamic_cast<FlexListLayouter*>(node->GetLayouter());
      if (layouter != 0)
      {
         GridLayouter* gridLayouter = dynamic_cast<GridLayouter*>(layouter->GetOriginalLayouter());
         if (gridLayouter != 0)
         {
            gridLayouter->SetLayout(orientationOperator.GetValue((Float)gridLayouter->GetRowCount(), (Float)value), orientationOperator.GetValue((Float)value, (Float)gridLayouter->GetColumnCount()));
         }
      }
   }
}
