/* ***************************************************************************************
* FILE:          GridAddingStrategy.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GridAddingStrategy is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(GridAddingStrategy_H)
#define GridAddingStrategy_H

#include "FeatStd/MemoryManagement/SharedPointer.h"
#include "ItemAdder.h"
#include "PositionsCalculator.h"
#include "AddingStrategy.h"
#include "GridItemAdder.h"
#include "GridPositionsCalculator.h"
#include "PositionsCache.h"
#include "Widgets/2D/List/Content/PageInfoCollectorWrapper.h"
#include "Widgets/2D/List/Content/Adders/GridLayoutingAdjuster.h"

class GridAddingStrategy : public AddingStrategy
{
      FEATSTD_TYPEDEF_BASE(AddingStrategy);

   public:
      FEATSTD_TYPEDEF_SHARED_POINTER(GridAddingStrategy);

      static GridAddingStrategy::SharedPointer Create(ISizeContainer& sizesContainer, const OrientationOperator& directOrientationOperator, const OrientationOperator& orthogonalOrientationOperator, const FeatStd::UInt8 rows, const FeatStd::UInt8 columns);

      virtual bool SupportsViewportPadding()
      {
         return true;
      }

      virtual LayoutingAdjuster* GetLayoutingAdjuster()
      {
         return &_layoutingAdjuster;
      }

   private:
      GridAddingStrategy(ISizeContainer& sizesContainer, const OrientationOperator& directOrientationOperator, const OrientationOperator& orthogonalOrientationOperator, const FeatStd::UInt8 rows, const FeatStd::UInt8 columns);

      ITemplateSpanAnalyzer::SharedPointer _templateSpanAnalyzer;
      GridOccupation _gridOccupation;
      const FeatStd::UInt8 _rows;
      const FeatStd::UInt8 _columns;
      PositionsCache _positionsCache;
      GridPositionsCalculator _positionsCalculator;
      PageInfoCollectorWrapper _infoCollector;
      GridLayoutingAdjuster _layoutingAdjuster;

      virtual const PositionsCalculator& GetPositionsCalculator() const override;
      virtual void CacheImpl(const ContentProvider& contentProvider, const ITemplateRetriever& templateRetriever) override;
      virtual ItemAdder::SharedPointer CreateItemAdderImpl(Candera::Node2D* groupNode) override;
      virtual void ProcessDataCHangedImpl(FeatStd::Int32 dataSize) override;
      virtual void AnalyzeTemplatesImpl(const ITemplateRetriever& templateRetriever) override;

      virtual FeatStd::Int32 CalculateStartIndexImpl(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::Float position) override;
      GridItemAdder::SharedPointer CreateGridItemAdder(Candera::Node2D* groupNode);

      virtual void CollectPagesInfoImpl(const ContentProvider& contentProvider,
                                        const AddChecker& addChecker,
                                        const ITemplateRetriever& templateRetriever,
                                        bool fixedPages,
                                        bool firstUpdateAfterNewData,
                                        FeatStd::Int32 indexOfFirstCompletelyVisibleElement,
                                        FeatStd::Int32 numberOfCompleteVisibleItems,
                                        bool circular,
                                        const Candera::Vector2 visibleArea) override;

      virtual const PagesInfo& GetPagesInfoImpl() const override;
};


#endif
