/* ***************************************************************************************
* FILE:          DistributeToAllItemsOGEmptyCellsPolicy.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DistributeToAllItemsOGEmptyCellsPolicy is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(DistributeToAllItemsOGEmptyCellsPolicy_H)
#define DistributeToAllItemsOGEmptyCellsPolicy_H

#include "OrthoGridEmptyCellsPolicy.h"

class DistributeToAllItemsOGEmptyCellsPolicy : public OrthoGridEmptyCellsPolicy
{
      FEATSTD_TYPEDEF_BASE(OrthoGridEmptyCellsPolicy);

   public:
      FEATSTD_TYPEDEF_SHARED_POINTER(DistributeToAllItemsOGEmptyCellsPolicy);

      static DistributeToAllItemsOGEmptyCellsPolicy::SharedPointer Create();

      virtual void AdjustSpans(const FeatStd::Int32 deltaSpan, Courier::Vector<FeatStd::Int8>& spans, const Courier::Vector<SpanInfo>& orderedSpans) override;

   private:
      DistributeToAllItemsOGEmptyCellsPolicy();
};


#endif
