/* ***************************************************************************************
* FILE:          AddingStrategy.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AddingStrategy is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(AddingStrategy_H)
#define AddingStrategy_H

#include "FeatStd/MemoryManagement/SharedPointer.h"
#include "ItemAdder.h"
#include "PositionsCalculator.h"
#include "Widgets/2D/List/Content/ISizeContainer.h"
#include "Widgets/2D/List/Content/AddChecker.h"
#include "Widgets/2D/List/Content/ITemplateRetriever.h"
#include "Widgets/2D/Common/PagesInfo.h"
#include "Widgets/2D/List/Swiping/Normalizer.h"

class LayoutingAdjuster;
class AddingStrategy
{
   public:
      FEATSTD_TYPEDEF_SHARED_POINTER(AddingStrategy);

      virtual ~AddingStrategy();

      ItemAdder::SharedPointer CreateItemAdder(Candera::Node2D* groupNode);

      virtual bool SupportsViewportPadding() = 0;

      virtual LayoutingAdjuster* GetLayoutingAdjuster()
      {
         return 0;
      }

      void Cache(const ContentProvider& contentProvider, const ITemplateRetriever& templateRetriever);
      void ProcessDataChanged(FeatStd::Int32 dataSize);
      void AnalyzeTemplates(const ITemplateRetriever& templateRetriever);

      FeatStd::Float CalculateStartingPosition(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::UInt32 startIndex);
      FeatStd::Int32 CalculateStartIndex(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::Float position);

      FeatStd::Float AdjustMaxPosition(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::UInt32 maxIndex);

      void CollectPagesInfo(const ContentProvider& contentProvider,
                            const AddChecker& addChecker,
                            const ITemplateRetriever& templateRetriever,
                            bool fixedPages,
                            bool firstUpdateAfterNewData,
                            FeatStd::Int32 indexOfFirstCompletelyVisibleElement,
                            FeatStd::Int32 numberOfCompleteVisibleItems,
                            bool circular,
                            const Candera::Vector2 visibleArea);

      const PagesInfo& GetPagesInfo() const;

      void SetNormalizer(Normalizer* val)
      {
         _normalizer = val;
      }

   protected:
      AddingStrategy(ISizeContainer& sizesContainer, const OrientationOperator& directOrientationOperator, const OrientationOperator& orthogonalOrientationOperator);

      ISizeContainer& _sizesContainer;
      const OrientationOperator& _directOrientationOperator;
      const OrientationOperator& _orthogonalOrientationOperator;

   private:
      FEATSTD_SHARED_POINTER_DECLARATION();

      Normalizer* _normalizer;

      virtual const PositionsCalculator& GetPositionsCalculator() const = 0;

      virtual ItemAdder::SharedPointer CreateItemAdderImpl(Candera::Node2D* groupNode) = 0;
      virtual void CacheImpl(const ContentProvider& contentProvider, const ITemplateRetriever& templateRetriever);
      virtual void ProcessDataCHangedImpl(FeatStd::Int32 dataSize);
      virtual void AnalyzeTemplatesImpl(const ITemplateRetriever& templateRetriever);

      virtual FeatStd::Float CalculateStartingPositionImpl(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::UInt32 startIndex);
      virtual FeatStd::Int32 CalculateStartIndexImpl(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::Float position);

      virtual FeatStd::Float AdjustMaxPositionImpl(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::UInt32 maxIndex);

      virtual void CollectPagesInfoImpl(const ContentProvider& contentProvider,
                                        const AddChecker& addChecker,
                                        const ITemplateRetriever& templateRetriever,
                                        bool fixedPages,
                                        bool firstUpdateAfterNewData,
                                        FeatStd::Int32 indexOfFirstCompletelyVisibleElement,
                                        FeatStd::Int32 numberOfCompleteVisibleItems,
                                        bool circular,
                                        const Candera::Vector2 visibleArea);

      virtual const PagesInfo& GetPagesInfoImpl() const = 0;
};


#endif
