/* ***************************************************************************************
* FILE:          AddingStrategy.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AddingStrategy is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "AddingStrategy.h"

using namespace FeatStd;

AddingStrategy::AddingStrategy(ISizeContainer& sizesContainer, const OrientationOperator& directOrientationOperator, const OrientationOperator& orthogonalOrientationOperator) :
   _sizesContainer(sizesContainer),
   _directOrientationOperator(directOrientationOperator),
   _orthogonalOrientationOperator(orthogonalOrientationOperator),
   _normalizer(0)
{
}


AddingStrategy::~AddingStrategy()
{
}


ItemAdder::SharedPointer AddingStrategy::CreateItemAdder(Candera::Node2D* groupNode)
{
   ItemAdder::SharedPointer adder(CreateItemAdderImpl(groupNode));
// void AddingStrategy::Clear()
   if (!adder.PointsToNull())
   {
      adder->SetNormalizer(_normalizer);
   }
// _sizesContainer.Clear();
   return adder;
}


void AddingStrategy::Cache(const ContentProvider& contentProvider, const ITemplateRetriever& templateRetriever)
{
   CacheImpl(contentProvider, templateRetriever);
}


void AddingStrategy::ProcessDataChanged(FeatStd::Int32 dataSize)
{
   ProcessDataCHangedImpl(dataSize);
}


void AddingStrategy::AnalyzeTemplates(const ITemplateRetriever& templateRetriever)
{
   AnalyzeTemplatesImpl(templateRetriever);
}


FeatStd::Float AddingStrategy::CalculateStartingPosition(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::UInt32 startIndex)
{
   return CalculateStartingPositionImpl(templateRetriever, contentProvider, startIndex);
}


FeatStd::Int32 AddingStrategy::CalculateStartIndex(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::Float position)
{
   return CalculateStartIndexImpl(templateRetriever, contentProvider, position);
}


FeatStd::Float AddingStrategy::AdjustMaxPosition(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::UInt32 maxIndex)
{
   return AdjustMaxPositionImpl(templateRetriever, contentProvider, maxIndex);
}


void AddingStrategy::CollectPagesInfo(const ContentProvider& contentProvider, const AddChecker& addChecker, const ITemplateRetriever& templateRetriever, bool fixedPages, bool firstUpdateAfterNewData, FeatStd::Int32 indexOfFirstCompletelyVisibleElement, FeatStd::Int32 numberOfCompleteVisibleItems, bool circular, const Candera::Vector2 visibleArea)
{
   CollectPagesInfoImpl(contentProvider, addChecker, templateRetriever, fixedPages, firstUpdateAfterNewData, indexOfFirstCompletelyVisibleElement, numberOfCompleteVisibleItems, circular, visibleArea);
}


const PagesInfo& AddingStrategy::GetPagesInfo() const
{
   return GetPagesInfoImpl();
}


void AddingStrategy::CacheImpl(const ContentProvider& /*contentProvider*/, const ITemplateRetriever& /*templateRetriever*/)
{
}


void AddingStrategy::ProcessDataCHangedImpl(FeatStd::Int32 /*dataSize*/)
{
}


void AddingStrategy::AnalyzeTemplatesImpl(const ITemplateRetriever& /*templateRetriever*/)
{
}


FeatStd::Float AddingStrategy::CalculateStartingPositionImpl(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::UInt32 startIndex)
{
   return GetPositionsCalculator().CalculateStartingPosition(templateRetriever, contentProvider, startIndex);
}


FeatStd::Int32 AddingStrategy::CalculateStartIndexImpl(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::Float position)
{
   return GetPositionsCalculator().CalculateStartIndex(templateRetriever, contentProvider, position);
}


FeatStd::Float AddingStrategy::AdjustMaxPositionImpl(const ITemplateRetriever& templateRetriever, const ContentProvider& contentProvider, const Candera::UInt32 maxIndex)
{
   return GetPositionsCalculator().CalculateStartingPosition(templateRetriever, contentProvider, maxIndex);
}


void AddingStrategy::CollectPagesInfoImpl(const ContentProvider& /*contentProvider*/, const AddChecker& /*addChecker*/, const ITemplateRetriever& /*templateRetriever*/, bool /*fixedPages*/, bool /*firstUpdateAfterNewData*/, FeatStd::Int32 /*indexOfFirstCompletelyVisibleElement*/, FeatStd::Int32 /*numberOfCompleteVisibleItems*/, bool /*circular*/, const Candera::Vector2 /*visibleArea*/)
{
}
