/* ***************************************************************************************
* FILE:          AddChecker.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AddChecker is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(AddChecker_H)
#define AddChecker_H

#include <FeatStd/Platform/Types.h>
#include <Widgets/2D/List/Content/Adders/ItemAdder.h>

class AddChecker
{
   public:
      AddChecker(const bool pixelWiseEnabled, const FeatStd::UInt32 configuredNumberOfItems);
      bool ShouldAdd(const ItemAdder& itemAdder, const bool vacantVisibleArea, const bool nextItemSizeZero = false) const;

   private:
      bool _pixelWiseEnabled;
      FeatStd::UInt32 _configuredNumberOfItems;
};


#endif
