/* ***************************************************************************************
* FILE:          MarginPropertySetter.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  MarginPropertySetter is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
#include <Candera/EngineBase/Layout/Layouter.h>
#else
#include <Candera/Engine2D/Layout/Layouter.h>
#endif

#include "MarginPropertySetter.h"

using namespace Candera;

MarginPropertySetter::MarginPropertySetter() :
   Base()
{
}


MarginPropertySetter* MarginPropertySetter::Create(Node2D* node)
{
   MarginPropertySetter* setter = FEATSTD_NEW(MarginPropertySetter);

   if (setter != 0)
   {
      setter->SetNode(node);
   }

   return setter;
}


void MarginPropertySetter::Set(const Float* value)
{
   Node2D* node = GetNode();
   if ((node != 0) && (value != 0))
   {
      Layouter* layouter = node->GetLayouter();
      if (layouter != 0)
      {
         Layouter::SetMargin(*node, Margin(
                                static_cast<Int16>(value[0]),
                                static_cast<Int16>(value[1]),
                                static_cast<Int16>(value[2]),
                                static_cast<Int16>(value[3])
                             ));
      }
   }
}
