/* ***************************************************************************************
* FILE:          ItemSpeedAnimationManager.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ItemSpeedAnimationManager is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef Item_Speed_Animation_Manager_H
#define Item_Speed_Animation_Manager_H

#include <FeatStd/Config.h>
#include <FeatStd/FeatStd.h>
#include <Widgets/2D/List/Swiping/SwipingListener.h>

#define BUFFER_SIZE 10
#define VELOCITY_MULTIPLIER 1000

class ItemSpeedAnimationManager
{
   public:
      ItemSpeedAnimationManager();

      /* Register size based on current swiping state and velocity */
      void RegisterSize(FeatStd::Float velocity, const SwipingState::Enum state);

      /* Get the margin size */
      inline FeatStd::UInt32 GetCurrentSize() const
      {
         return _currentSize;
      }

      /* Compute current frame size of margin for speed animation */
      void ComputeCurrentSize();

      /* Check if sizes animation requires update */
      inline bool RequiresUpdate() const
      {
         return _isActive;
      }

   private:

      FeatStd::Float GetSizeFromVelocity(FeatStd::Float velocity);
      void InsertNewSize(FeatStd::Float velocity);
      FeatStd::Float GetSizeMed();

      /* Circular buffer */
      FeatStd::Float _sizes[BUFFER_SIZE];
      /* Circular buffer current zise */
      FeatStd::Int32 _sizesCount;
      /* Circular buffer current position */
      FeatStd::Int32 _currentPosition;

      bool _isActive;
      FeatStd::UInt32 _currentSize;
      SwipingState::Enum _swipingState;
};


#endif
