/* ***************************************************************************************
* FILE:          FlexListLimiter.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FlexListLimiter is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef FLEX_LIST_LIMITER_H
#define FLEX_LIST_LIMITER_H

#include <Candera/Candera.h>
#include <Widgets/2D/List/generated/ListMessages.h>

namespace LimiterState {
enum Enum
{
   SingleItemStepExceedUp,
   SingleItemStepExceedDown,
   MultiItemStepExceedUp,
   MultiItemStepExceedDown,
   MultiItemLimitReachUp,
   MultiItemLimitReachDown,
   Idle
};


}


class LimitListener
{
   public:
      virtual ~LimitListener() { }

      virtual void OnLimitExceededUp() = 0;
      virtual void OnLimitExceededDown() = 0;
      virtual void OnLimitReachedUp() = 0;
      virtual void OnLimitReachedDown() = 0;
};


class FlexListLimiter
{
   public:

      FlexListLimiter();
      ~FlexListLimiter();

      void OnListChangeMessage(const ListChangeMsg& msg);

      void SetLimiterState(LimiterState::Enum state)
      {
         _limiterState = state;
      }
      void SetCurrentValues(Candera::Int32 focusIndex, Candera::UInt32 first, Candera::UInt32 nrOfItems, Candera::UInt32 listSize, bool isCircularScrollingActive);
      void CommitValues();

      void RegisterListener(LimitListener* listener)
      {
         _listener = listener;
      }

   private:
      LimiterState::Enum _limiterState;

      LimitListener* _listener;

      Candera::Int32 _previousFocusIndex;
      Candera::UInt32 _previousStartIndex;
      Candera::UInt32 _previousNumberOfItems;

      Candera::Int32 _currentFocusIndex;
      Candera::UInt32 _currentStartIndex;
      Candera::UInt32 _currentNumberOfItems;

      Candera::UInt32 _listSize;
      bool _isCircularScrolling;

      bool CheckSingleItemStepExceededUp() const;
      bool CheckSingleItemStepExceededDown() const;
      bool CheckMultiItemStepExceededUp() const;
      bool CheckMultiItemStepExceededDown() const;
      bool CheckLimitReachedUp() const;
      bool CheckLimitReachedDown() const;
};


#endif
