/* ***************************************************************************************
* FILE:          ExpandTriggerManager.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ExpandTriggerManager is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef ExpandTriggerManager_H
#define ExpandTriggerManager_H

#include "Widgets/2D/ControlTemplate/ControlTemplateInstanceContainer.h"

class ListDataWrapper;
class ExpandTriggerManager
{
   public:
      ExpandTriggerManager(ControlTemplateInstanceContainer& itemsInstanceContainer, const ListDataWrapper* listData);
      ~ExpandTriggerManager();

      void SetTimeDispatcher(const Candera::Animation::AnimationTimeDispatcher::SharedPointer& timeDispatcher);

      /**
       * Marks the expand animations of the item with the given dataItemto be started in the given
       * direction by the next call to UpdateAnimationStatus
       *
       * @return true if animations should be started; false otherwise
       */
      bool MarkToStart(FeatStd::UInt32 relativeItemIndex, bool forward);

      /**
      * Updates the running status of the previously marked animations
      *
      * @return true if any animation has been started; false otherwise
      */
      bool UpdateAnimation();

      /**
      * Set the expand / collapse state of the given template instance
      *
      * @return true if a state was changed
      **/
      bool UpdateItemState(ControlTemplateInstance* templateInstance);

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(ExpandTriggerManager);

      enum PlaybackType
      {
         Forward,
         Backward,
         ReverseCurrent
      };

      struct IndexInfo
      {
         FeatStd::Int32 index;
         PlaybackType playbackType;
      } ;

      typedef Courier::Vector<IndexInfo> IndicesInfo;

      ControlTemplateInstanceContainer& _itemsInstanceContainer;
      IndicesInfo _markedIndices;   // indices of item currently expanding/collapsing
      Candera::Animation::AnimationTimeDispatcher::SharedPointer _timeDispatcher;
      const ListDataWrapper* _listData;
};


#endif
