/* ***************************************************************************************
* FILE:          ExpandAdjuster.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ExpandAdjuster is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef ExpandAdjuster_H
#define ExpandAdjuster_H

#include <Widgets/2D/List/Content/ItemSizesContainer.h>
#include <Widgets/2D/List/Swiping/Normalizer.h>
#include <Widgets/2D/List/Swiping/PositioningHandler.h>

class ExpandAdjuster
{
   public:
      struct AdjustData
      {
         bool _lastViewport;
         bool _lastIsRunning;
         bool _lastIsForward;
         FeatStd::Int32 _lastRunningIndex;
      };

      ExpandAdjuster(ItemSizesContainer* sizesContainer, PositioningHandler& positioner);

      ~ExpandAdjuster();

      void SetNormalizer(Normalizer* normalizer)
      {
         _normalizer = normalizer;
      }

      FeatStd::Int32 GetAdjustingItemIndex()
      {
         return _currentAdjustingItemIndex;
      }

      void PrepareAdjustment(const bool lastViewPort);

      void ExpandStarted(const AdjustData& data, FeatStd::Int16 endMargin);

      bool Adjust(const AdjustData& data, FeatStd::Int16 endMargin);

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(ExpandAdjuster);

      ItemSizesContainer* _sizesContainer;
      Normalizer* _normalizer;
      PositioningHandler& _positioner;

      /* The initial margin of the expanding item */
      FeatStd::Int16 _initialMargin;

      /* Expanding item index */
      FeatStd::Int32 _currentAdjustingItemIndex;
};


#endif
