/* ***************************************************************************************
* FILE:          CustomAnimationsContainer.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CustomAnimationsContainer is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef CustomAnimationsContainer_H
#define CustomAnimationsContainer_H

#include <Candera/EngineBase/Animation/AnimationController.h>
#include <Candera/EngineBase/Animation/AnimationTimeType.h>
#include <Courier/Util/Vector.h>
#include "Candera/EngineBase/Animation/AnimationPlayerListener.h"
#include "Candera/EngineBase/Animation/AnimationPlayer.h"
#include "Candera/EngineBase/Animation/AnimationGroupPlayer.h"
#include "Candera/EngineBase/Animation/AnimationTimeDispatcher.h"
#include <Widgets/2D/Common/AnimationsContainer.h>
#include <Widgets/2D/List/generated/ListEnums.h>
#include "CanderaAssetLoader/AssetLoaderBase/ArrayProperty.h"
#include "CustomAnimationEntity.h"
#include "TimeDispatcherRegistrar.h"


/**
 * The CustomAnimationsContainer is a container for all custom animations from the list widget.
 */
class CustomAnimationsContainer : private TimeDispatcherRegistrar
{
   public:
      CustomAnimationsContainer(Candera::ArrayProperty<Candera::Animation::AnimationPlayer::SharedPointer>& animations);

      virtual ~CustomAnimationsContainer();

      void SetAnimationsGroup(Candera::Node2D* val);
      void SetItemsGroup(Candera::Node2D* val);
      void SetOwnerId(FeatStd::UInt32 val);

      /**
       * Processes the given message.
       * @param invalidate - returns whether an invalidation should be performed or not
       * @return whether the message is consumed or not.
       */
      bool ProcessMessage(const Courier::Message& msg, bool& invalidate);

      /**
       * Updates the status based on the given world time
       */
      void Update(Candera::Animation::WorldTimeType worldTime);

      /**
       * Returns if whether at least one of the inner animations is running
       */
      bool IsRunning() const;
   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(CustomAnimationsContainer);

      typedef Courier::Vector<CustomAnimationEntity> CustomAnimations;

      FeatStd::UInt32 _ownerId;
      CustomAnimations _animations;
      Candera::Animation::AnimationTimeDispatcher::SharedPointer _timeDispatcher;
      Candera::ArrayProperty<Candera::Animation::AnimationPlayer::SharedPointer>& _allAnimations;
      Candera::Node2D* _animationsGroup;
      Candera::Node2D* _itemsGroup;

      void Start(Courier::ItemId animationId);
      void Hold(Courier::ItemId animationId, CustomListAnimationAction action);

      CustomAnimationEntity* GetAnimation(Courier::ItemId animationId);

      virtual void Register(const Candera::Animation::AnimationPlayerBase::SharedPointer& player) override;
      virtual void UnRegister(const Candera::Animation::AnimationPlayerBase::SharedPointer& player) override;
};


#endif
