/* ***************************************************************************************
* FILE:          CustomAnimationEntity.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CustomAnimationEntity is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef CustomAnimationEntity_H
#define CustomAnimationEntity_H

#include "Candera/EngineBase/Animation/AnimationTimeType.h"
#include "Candera/EngineBase/Animation/AnimationPlayer.h"
#include "Widgets/2D/List/generated/ListEnums.h"
#include "TimeDispatcherRegistrar.h"

/**
 * The CustomAnimation is a container for all custom animations from the list widget.
 */
class CustomAnimationEntity : private Candera::Animation::AnimationPlayerListener
{
   public:
      typedef Candera::Animation::AnimationPlayer::SharedPointer Player;

      enum HoldType
      {
         Start,
         End,
         None
      };

      CustomAnimationEntity(Player original, FeatStd::UInt32 ownerId);
      CustomAnimationEntity(const CustomAnimationEntity& other);
      CustomAnimationEntity& operator=(const CustomAnimationEntity& other);

      virtual ~CustomAnimationEntity();

      void SetAnimationsGroup(Candera::Node2D* val)
      {
         _animationsGroup = val;
      }

      void SetItemsGroup(Candera::Node2D* val)
      {
         _itemsGroup = val;
      }

      bool HasId(Courier::ItemId id);
      void PrepareForPlay();
      void PrepareForHold(HoldType val);
      void Update(TimeDispatcherRegistrar& registrar);

      bool IsRunning() const;
   private:
      enum Status
      {
         Idle,
         MarkedForPlaback,
         Running
      };

      FeatStd::UInt32 _ownerId;
      Status _status;
      HoldType _hold;
      Candera::Animation::AnimationPlayer::SharedPointer _original;
      Candera::Animation::AnimationPlayer::SharedPointer _clone;
      Candera::Node2D* _animationsGroup;
      Candera::Node2D* _itemsGroup;

      void CloneOriginal();
      void Play(TimeDispatcherRegistrar& registrar);
      void Hold();
      void AdjustWhileRunning(TimeDispatcherRegistrar& registrar);
      void PostResMsg(CustomListAnimationAction action, bool success) const;
      CustomListAnimationAction GetHoldAction() const;

      virtual void OnPastEnd(Candera::Animation::AnimationPlayerBase* animationPlayer, Candera::Int32 completedIterationsCount);

      void Stop();
};


#endif
