/* ***************************************************************************************
* FILE:          AnimationFactory.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AnimationFactory is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "AnimationFactory.h"

using namespace Candera;

Candera::MemoryManagement::SharedPointer<Animation::AnimationPlayer> AnimationFactory::CreatePlainAnimation()
{
   Candera::MemoryManagement::SharedPointer<Animation::AnimationPlayer> result = Animation::AnimationPlayer::Create();
   if (!result.PointsToNull())
   {
      result->SetRepeatCount(1);
      result->SetSpeedFactor(1.0F);
   }

   return result;
}
