/* ***************************************************************************************
* FILE:          MarginWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  MarginWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "MarginWidget2D.h"


CGI_WIDGET_RTTI_DEFINITION(MarginWidget2D);


MarginWidget2D::MarginWidget2D() : _invalid(true)
{
}


MarginWidget2D::~MarginWidget2D()
{
}


void MarginWidget2D::Update()
{
   if (_invalid && (0 != GetNode()))
   {
      Candera::Node2D* node = GetNode();
      if (0 != node)
      {
         Candera::Layouter::SetMargin(*node, Candera::Margin(static_cast<Candera::Int16>(GetMarginLeft()), static_cast<Candera::Int16>(GetMarginTop()),
                                      static_cast<Candera::Int16>(GetMarginRight()), static_cast<Candera::Int16>(GetMarginBottom())));
         Invalidate();
      }
      _invalid = false;
   }
}


bool MarginWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned(false);
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const MarginWidget2D* original = CLONEABLE_WIDGET_CAST<const MarginWidget2D*>(originalWidget);
      if (original == NULL)
      {
         return false;
      }

      SetMarginLeft(original->GetMarginLeft());
      SetMarginTop(original->GetMarginTop());
      SetMarginRight(original->GetMarginRight());
      SetMarginBottom(original->GetMarginBottom());

      cloned = true;
   }
   return cloned;
}


void MarginWidget2D::OnChanged(Courier::UInt32 propertyId)
{
   Base::OnChanged(propertyId);

   _invalid = true;
}


void MarginWidget2D::OnNodeChanged()
{
   _invalid = true;
   triggerUpdate();
}
