/* ***************************************************************************************
* FILE:          LabelWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  LabelWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "Widgets/2D/Label/LabelWidget2D.h"
#include <Candera/TextEngine/TextLayoutStrategy.h>


#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_TEXT
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/LabelWidget2D.cpp.trc.h"
#endif

#include "Widgets/2D/ControlTemplate/ControlTemplateBinding.h"


CGI_WIDGET_RTTI_DEFINITION(LabelWidget2D);


/******************************************************************************
*  Constructor
******************************************************************************/
LabelWidget2D::LabelWidget2D() :
   FEATSTD_SUPPRESS_MSC_WARNING_FOR_NEXT_EXPRESSION(4355, "'this' is just stored, but not used now.")
   _textNode(0),
   _dirty(true)
{
   /// SetTruncationText("...");
}


/***************************************************************************
*     destructor
****************************************************************************/
LabelWidget2D::~LabelWidget2D()
{
   _textNode = 0;
}


/***************************************************************************
*  InitWidget
****************************************************************************/
void LabelWidget2D::InitWidget()
{
   Base::InitWidget();
   Update();
}


/******************************************************************************
*  Update
******************************************************************************/
void LabelWidget2D::Update()
{
   if (IsDirty() && GetNode() != 0)
   {
      _textNode = Candera::Dynamic_Cast<Candera::TextNode2D*>(GetNode());
      if (_textNode != 0)
      {
         _textNode->SetText(GetText());
      }
      ResetDirty();
      Invalidate();
   }
}


/****************************************************************************
*  Called when Localization/Culture has changed during runtime
****************************************************************************/
void LabelWidget2D::CultureChanged()
{
   SetDirty();
   triggerUpdate();
}


/****************************************************************************
*  Message object to be processed.
*  Returns true of message is consumed
****************************************************************************/
bool LabelWidget2D::OnMessage(const Message& msg)
{
   return Base::OnMessage(msg);
}


/******************************************************************************
*  CloneFrom
******************************************************************************/
bool LabelWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget,
                              ControlTemplateMap& controlTemplateMap)
{
   bool cloned(false);
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const LabelWidget2D* original = CLONEABLE_WIDGET_CAST<const LabelWidget2D*>(originalWidget);
      if (original == NULL)
      {
         return false;
      }

      if (ControlTemplateBinding::IsTextBindable(*this))
      {
         SetText(ControlTemplateBinding::GetTextValue(*this));
      }
      else
      {
         SetText(original->GetText());
      }

      cloned = true;
   }
   return cloned;
}


/******************************************************************************
*  OnChanged
******************************************************************************/
void LabelWidget2D::OnChanged(::FeatStd::UInt32 propertyId)
{
   Base::OnChanged(propertyId);

   SetDirty();
}
