/* ***************************************************************************************
* FILE:          GizmoWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GizmoWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "GizmoWidget2D.h"
#include "GizmoController2D.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_GIZMO
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include <trcGenProj/Header/GizmoWidget2D.cpp.trc.h>
#endif


namespace hmibase {
namespace widget {
namespace gizmo {


CGI_WIDGET_RTTI_DEFINITION(GizmoWidget2D);


/*****************************************************************************/
GizmoWidget2D::GizmoWidget2D() : Base()
{
   //make the widget touchable and enable drag gestures
   SetTouchable(true);
   SetDrag(true);
}


/*****************************************************************************/
GizmoWidget2D::~GizmoWidget2D()
{
}


/*****************************************************************************/
bool GizmoWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned = false;
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const GizmoWidget2D* original = CLONEABLE_WIDGET_CAST<const GizmoWidget2D*>(originalWidget);
      if (original != NULL)
      {
         SetLimitArea(original->GetLimitArea());
         SetMinimumSize(original->GetMinimumSize());
         SetMaximumSize(original->GetMaximumSize());

         // avoid getting the position, size and rotation from the template if this widget is part of a page edit
         if (!IsOwnedByPageEdit())
         {
            SetPosition(original->GetPosition());
            SetSize(original->GetSize());
            SetRotation(original->GetRotate());
         }

         SetColorIndex(original->GetColorIndex());

         SetGizmoEditModes(original->GetGizmoEditModes());
         SetColors(original->GetColors());

         controlTemplateMap.ResolveNodeCloneArray(GetNodes(), original->GetNodes());

         cloned = true;
      }
   }
   return cloned;
}


/*****************************************************************************/
hmibase::widget::WidgetController* GizmoWidget2D::GetDefaultController() const
{
   return &(DefaultGizmoController2D::getInstance());
}


}
}


}
