/* ***************************************************************************************
* FILE:          GestureWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GestureWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef Gesture_WIDGET2D_H
#define Gesture_WIDGET2D_H

#include <Widgets/2D/Gesture/generated/GestureWidget2DBase.h>
#include <Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h>
#include <View/CGI/Widget/WidgetController.h>


namespace hmibase {
namespace widget {
namespace gesture {

/*****************************************************************************/
class GestureWidget2D;


/*****************************************************************************/
/* Base class for all gesture controllers. */
class GestureController2D : public hmibase::widget::WidgetController
{
      FEATSTD_TYPEDEF_BASE(hmibase::widget::WidgetController);

   public:
      CANDERA_RTTI_DECLARATION(GestureController2D);

      virtual ~GestureController2D() {}

      WIDGET_CONTROLLER_ON_GESTURE()
      virtual bool OnTapGesture(DelegateWidget& widget, const hmibase::input::gesture::GestureEvent& gestureData);
      virtual bool OnDragGesture(DelegateWidget& widget, const hmibase::input::gesture::GestureEvent& gestureData);
      virtual bool OnSwipeGesture(DelegateWidget& widget, const hmibase::input::gesture::GestureEvent& gestureData);
      virtual bool OnPinchSpreadGesture(DelegateWidget& widget, const hmibase::input::gesture::GestureEvent& gestureData);
      virtual bool OnRotateGesture(DelegateWidget& widget, const hmibase::input::gesture::GestureEvent& gestureData);

      virtual bool postTapGestureMessage(DelegateWidget& widget, const hmibase::input::gesture::GestureEvent& gestureData) = 0;
      virtual bool postDragGestureMessage(DelegateWidget& widget, const hmibase::input::gesture::GestureEvent& gestureData) = 0;
      virtual bool postSwipeGestureMessage(DelegateWidget& widget, const hmibase::input::gesture::GestureEvent& gestureData) = 0;
      virtual bool postPinchSpreadGestureMessage(DelegateWidget& widget, const hmibase::input::gesture::GestureEvent& gestureData) = 0;
      virtual bool postRotateGestureMessage(DelegateWidget& widget, const hmibase::input::gesture::GestureEvent& gestureData) = 0;
};


/*****************************************************************************/
/*
*/
class DefaultGestureController2D : public GestureController2D
{
      FEATSTD_TYPEDEF_BASE(GestureController2D);

   public:
      CANDERA_RTTI_DECLARATION(DefaultGestureController2D);

      virtual ~DefaultGestureController2D() {}

      /* Singleton instance. */
      static DefaultGestureController2D& getInstance()
      {
         static DefaultGestureController2D instance;
         return instance;
      }

      /*****************************************************************************/
      /* Delegate methods */
      virtual enGestureEvent::Enum getGestureEvent(hmibase::input::gesture::GestureEvent::GestureState gestureState);
      virtual bool postTapGestureMessage(DelegateWidget& widget, const hmibase::input::gesture::GestureEvent& gestureData) override;
      virtual bool postDragGestureMessage(DelegateWidget& widget, const hmibase::input::gesture::GestureEvent& gestureData) override;
      virtual bool postSwipeGestureMessage(DelegateWidget& widget, const hmibase::input::gesture::GestureEvent& gestureData) override;
      virtual bool postPinchSpreadGestureMessage(DelegateWidget& widget, const hmibase::input::gesture::GestureEvent& gestureData) override;
      virtual bool postRotateGestureMessage(DelegateWidget& widget, const hmibase::input::gesture::GestureEvent& gestureData) override;
};


/*****************************************************************************/
/*
*/
class GestureWidget2D : public GestureWidget2DBase
{
   public:

      CGI_WIDGET_RTTI_DECLARATION(GestureWidget2D, GestureWidget2DBase);

      /*****************************************************************************/
      GestureWidget2D();
      virtual ~GestureWidget2D();

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap) override;

      virtual WidgetController* GetDefaultController() const override;

      /*****************************************************************************/
      /* Widget definition */
      CdaWidget2DDef(GestureWidget2D, GestureWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()
};


}
}


}

HMIBASE_DEPRECATED_TYPE_ALIAS(GestureWidgetController, hmibase::widget::gesture::GestureController2D);
HMIBASE_DEPRECATED_TYPE_ALIAS(DefaultGestureWidgetController, hmibase::widget::gesture::DefaultGestureController2D);
HMIBASE_DEPRECATED_TYPE_ALIAS(GestureWidget2D, hmibase::widget::gesture::GestureWidget2D);

#endif
