/* ***************************************************************************************
* FILE:          Focusable2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Focusable2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef __FOCUSABLE2D_H__
#define __FOCUSABLE2D_H__

#include "Focus/FCommon.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"

class BaseWidget2D;
namespace Candera {
class Node2D;
}


namespace Focus {
class FManager;
class FSession;
class FWidgetConfig;
}


class Focusable2DBase
{
   public:
      Focusable2DBase();
      virtual ~Focusable2DBase();

      /////////////////////////////////////////////////////////////////////////
      //visibility in scene composer
      //todo: use a compiler switch for build on target/simulation
      virtual bool IsFocusPropertyVisible() const
      {
         return true;
      }
      virtual bool AreFocusRelatedPropertiesVisible() const
      {
         return IsFocusPropertyVisible() && GetFocusableStatus();
      }

   protected:
      /////////////////////////////////////////////////////////////////////////
      //interaction with focus manager
      void ConfigureFocusControllers(BaseWidget2D& widget, const Focus::FManager& focusManager, Focus::FSession& session, Focus::FWidgetConfig& handle, Focus::FControllerSetId controllerSetId);
      void RegisterToFocusManager(BaseWidget2D& widget);
      void DefaultRegisterToFocusManagerImpl(BaseWidget2D& widget, Focus::FManager& focusManager, Focus::FSession& session, Focus::FWidgetConfig& handle);
      virtual void RegisterToFocusManagerImpl(Focus::FManager& focusManager, Focus::FSession& session, Focus::FWidgetConfig& handle) = 0;

      void UpdateFocusable(BaseWidget2D& widget);

      /////////////////////////////////////////////////////////////////////////
      //support or usage in lists
      void CloneFocusableFrom(const Focusable2DBase& original, ControlTemplateMap& controlTemplateMap);

      /////////////////////////////////////////////////////////////////////////
      //fields
#define DefFocusProperty(propType, propName)\
   public:\
      typedef propType propName##Type;\
      propType Get##propName() const { return _##propName; }\
      void Set##propName(propType value) { _##propName = value; }\
   private:\
      propType _##propName;

      DefFocusProperty(bool, FocusableStatus)
      DefFocusProperty(Candera::Node2D*, FocusParentNode)
      DefFocusProperty(short, FocusOrder)
      DefFocusProperty(short, FocusControllerSet)

#undef DefFocusProperty
};


#define CdaProperty_Focusable()\
      CdaBindableProperty(Focusable, FocusableStatusType, GetFocusableStatus, SetFocusableStatus)\
      CdaDescription("Widget can gain the focus.")\
      CdaCategory("Focus")\
      CdaVisibilityTest(IsFocusPropertyVisible)\
      CdaBindablePropertyEnd()

#define CdaProperty_FocusParentNode()\
      CdaProperty(FocusParentNode, FocusParentNodeType, GetFocusParentNode, SetFocusParentNode)\
      CdaDescription("Node of the parent focus group. If it is not specified a search will be performed to find a focus group linked to the closest ancestor node.")\
      CdaCategory("Focus")\
      CdaVisibilityTest(AreFocusRelatedPropertiesVisible)\
      CdaPropertyEnd()

#define CdaProperty_FocusControllerSet()\
      CdaBindableProperty(FocusControllerSet, FocusControllerSetType, GetFocusControllerSet, SetFocusControllerSet)\
      CdaDescription("The application can associate a list of focus controllers (ControllerSet) to a numerical id. Those controllers can be used for a widget based on the same id.")\
      CdaCategory("Focus")\
      CdaVisibilityTest(AreFocusRelatedPropertiesVisible)\
      CdaBindablePropertyEnd()

#define CdaProperty_FocusOrder()\
      CdaBindableProperty(FocusOrder, FocusOrderType, GetFocusOrder, SetFocusOrder)\
      CdaDescription("Focus order. Zero has the highest priority.")\
      CdaCategory("Focus")\
      CdaVisibilityTest(AreFocusRelatedPropertiesVisible)\
      CdaBindablePropertyEnd()

#endif
