/* ***************************************************************************************
* FILE:          FocusUtils2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FocusUtils2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef __FOCUS_UTILS_2D_H__
#define __FOCUS_UTILS_2D_H__

class BaseWidget2D;
namespace Candera {
class Scene2DContext;
class Node2D;
}


namespace Focus {
class FWidgetConfig;
}


class FocusUtils
{
   public:
      //searches for focusable widget which is linked to a node being a descendent of the specified node
      static bool setFocusOnDescendent(Candera::Scene2DContext* context, Candera::Node2D* node);

      static Focus::FWidgetConfig* getFocusableHandle(BaseWidget2D& widget);

      static bool isFocused(BaseWidget2D& widget);
      static bool isFocusGroup(BaseWidget2D& widget);
};


#endif
