/* ***************************************************************************************
* FILE:          ColorEffectWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ColorEffectWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "ColorEffectWidget2D.h"


#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_EFFECTCONTROL
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/ColorEffectWidget2D.cpp.trc.h"
#endif


CGI_WIDGET_RTTI_DEFINITION(ColorEffectWidget2D);

ColorEffectWidget2D::ColorEffectWidget2D() : Base()
{
}


ColorEffectWidget2D::~ColorEffectWidget2D()
{
}


bool ColorEffectWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   if (!Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      return false;
   }

   const ColorEffectWidget2D* original = CLONEABLE_WIDGET_CAST<const ColorEffectWidget2D*>(originalWidget);
   if (original == NULL)
   {
      return false;
   }

   hmibase::widget::utils::EffectUtils::copyColor(original->GetNode(), GetNode());

   return true;
}
