/* ***************************************************************************************
* FILE:          DropDownListWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DropDownListWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef DropDown_List_Widget_2D_H
#define DropDown_List_Widget_2D_H

#include "Widgets/2D/DropDownList/generated/DropDownListWidget2DBase.h"
#include "Widgets/2D/List/Content/DefaultListContentUpdater.h"

class DropDownListWidget2D: public DropDownListWidget2DBase
{
   public:
      // fr83hi typedef bool (*FocusStrategy)(FlexListWidget2D& listWidget, const ListChangeMsg& msg);

      // fr83hi static void SetFocusStrategy(FocusStrategy focusStrategy);

      CGI_WIDGET_RTTI_DECLARATION(DropDownListWidget2D, DropDownListWidget2DBase);

      DropDownListWidget2D();
      virtual ~DropDownListWidget2D();

      virtual void Finalize();

      virtual void OnChanged(Courier::UInt32 propertyId);
      virtual bool OnMessage(const Courier::Message& msg);

      void OnOpenChanged();

      virtual Candera::UInt32 GetEffectiveTouchPriority() const;
      virtual void InitWidget();

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      CdaWidget2DDef(DropDownListWidget2D, DropDownListWidget2DBase)

      CdaDescription("Provides support to implement comboboxes (which are composed by a button and a dropdown list).")
      CdaReadableName("DropDownListWidget2D")
      CdaCategory("List")

      CdaProperties() //Start of properties
      CdaPropertiesEnd() // End of properties

      CdaWidgetDefEnd()

   protected:
   private:
      bool _open;
      Candera::Int32 _selected;
      bool _delayUpdateContent;

      virtual void PerformUpdate(bool& invalidate, bool& invalidateLayout);
};


#endif
