/* ***************************************************************************************
* FILE:          DDModelBase.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DDModelBase is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "Widgets/2D/BaseWidget2D.h"
#include "DDModelBase.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_DRAG_DROP
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/DDModelBase.cpp.trc.h"
#endif

namespace DragDrop {
DDModelBase::DDModelBase()
{
}


DDModelBase::~DDModelBase()
{
}


bool DDModelBase::onCourierMessage(const DragDropCheckSourceReqMsg& msg)
{
   bool result = isValidSource(msg);
   sendCheckSourceRes(msg.GetReqId(), 0, result);
   return true;
}


void DDModelBase::sendCheckSourceRes(FeatStd::UInt32 reqId, FeatStd::UInt32 sourceData, bool result)
{
   POST_MSG((COURIER_MESSAGE_NEW(DragDropCheckSourceResMsg)(reqId, sourceData, result)));
}


bool DDModelBase::onCourierMessage(const DragDropCheckDestinationReqMsg& msg)
{
   bool result = isValidDestination(msg);
   sendCheckDestinationRes(msg.GetReqId(), 0, result);
   return true;
}


void DDModelBase::sendCheckDestinationRes(FeatStd::UInt32 reqId, FeatStd::UInt32 destinationData, bool result)
{
   POST_MSG((COURIER_MESSAGE_NEW(DragDropCheckDestinationResMsg)(reqId, destinationData, result)));
}


bool DDModelBase::onCourierMessage(const DragDropCompleteReqMsg& msg)
{
   bool result = executeDrop(msg);
   sendCompleteRes(msg.GetReqId(), result);
   return true;
}


void DDModelBase::sendCompleteRes(FeatStd::UInt32 reqId, bool result)
{
   POST_MSG((COURIER_MESSAGE_NEW(DragDropCompleteResMsg)(reqId, result)));
}


bool DDModelBase::onCourierMessage(const DragDropStatusUpdMsg& msg)
{
   (void)msg;
   return false;//don't consume this status update message
}


}
