/* ***************************************************************************************
* FILE:          DDManager.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DDManager is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(_DRAG_DROP_MANAGER_H)
#define _DRAG_DROP_MANAGER_H

#include <BaseContract/generated/BaseMsgs.h>
#include <View/CGI/CgiExtensions/MessageHandler.h>
#include <Widgets/2D/Adorner/DefaultAdorner.h>

namespace Candera {
class Widget2D;
class Node2D;
}


namespace Util {
class Timer;
}


class AppViewHandler;

class BaseWidget2D;
class Touchable2D;

namespace DragDrop {
class DDAdorner;

class DDManager : public ::hmibase::view::MessageHandler
{
   private:
      struct ViewWidgetId
      {
         ViewWidgetId() {}
         ViewWidgetId(const Courier::ViewId& view, const FeatStd::String& widget) : View(view), Widget(widget) {}

         Courier::ViewId View;
         FeatStd::String Widget;
      };

      enum PendingOperationType
      {
         PendingNone,
         PendingStartTimer,
         PendingCheckSource,
         PendingCheckDestination,
         PendingComplete
      };

      struct PendingOperation
      {
         PendingOperation() : OpType(PendingNone), ReqId(0) {}

         PendingOperationType OpType;
         FeatStd::UInt32 ReqId;
         ViewWidgetId ViewWidget;
      };

      struct DragDropInfo
      {
         DragDropInfo() : SessionId(0), SourceData(0), DestinationData(0) {}

         FeatStd::UInt32 SessionId;
         Courier::ViewId SourceView;
         FeatStd::String SourceWidget;
         FeatStd::UInt32 SourceData;
         Courier::ViewId DestinationView;
         FeatStd::String DestinationWidget;
         FeatStd::UInt32 DestinationData;
      };

   public:
      static DDManager& getInstance();

      bool onTouchPress(Touchable2D& sourceWidget, const Courier::TouchInfo& touchInfo);
      bool onTouchMove(Touchable2D& sourceWidget, const Courier::TouchInfo& touchInfo);
      bool onTouchRelease(Touchable2D& sourceWidget, const Courier::TouchInfo& touchInfo);
      void cancelOperation();

      virtual bool onMessage(const Courier::Message& msg);

      void setViewHandler(AppViewHandler* viewHandler);
      AppViewHandler* getViewHandler() const;
      void setDragStartTimerTimeout(FeatStd::UInt32 timeout);
      void setAdornerManager(hmibase::widget::adorner::AdornerManager* adornerManager);

      /* if set to non NULL, then the drag drop manager will only accept touch messages (onTouchXyz) from the specified widget, otherwise touch messages from any widget will be accepted. */
      void setAcceptedTouch(Touchable2D* widget);
      Touchable2D* getAcceptedTouch() const;

   private:
      DDManager();
      virtual ~DDManager();

      DDManager(const DDManager&);
      DDManager& operator=(const DDManager&);

      bool checkPendingOperation(PendingOperationType OpType, FeatStd::UInt32 reqId = 0);
      void clearPendingOperation();

      void sendCheckSourceReq(const ViewWidgetId& viewWidgetId);
      void onCheckSourceRes(FeatStd::UInt32 reqId, FeatStd::UInt32 sourceData, bool result);

      void checkDestination(const Courier::TouchInfo& touchMoveInfo);
      void sendCheckDestinationReq(const ViewWidgetId& viewWidgetId);
      void onCheckDestinationRes(FeatStd::UInt32 reqId, FeatStd::UInt32 destinationData, bool result);

      void sendCompleteReq();
      void onCompleteRes(FeatStd::UInt32 reqId, bool result);

      void sendStatusInfo(hmibase::DragDropStatusEnum status);

      void startDragStartTimer();
      void stopDragStartTimer();
      void onDragStartTimerExpired();

      void initSession();
      void endSession();
      void clearSession();

      Touchable2D* findSourceWidget(const Courier::TouchInfo& touchInfo);
      Touchable2D* findDestinationWidget(const Courier::TouchInfo& touchInfo);

      FeatStd::UInt32 getNextSessionId();
      FeatStd::UInt32 getNextRequestId();

      //hmibase::widget::adorner::AdornerManager& getAdornerManager();
      void createAdorner(Touchable2D& widget, const Courier::TouchInfo& touchInfo);
      void destroyAdorner();
      void showAdorner();
      void hideAdorner();
      void moveAdorner(const Courier::TouchInfo& touchInfo);

      AppViewHandler* _viewHandler;
      Util::Timer* _dragStartTimer;
      FeatStd::UInt32 _dragStartTimerTimeout;

      FeatStd::UInt32 _nextSessionId;
      FeatStd::UInt32 _nextRequestId;

      bool _touched;
      Touchable2D* _acceptedTouch;
      DragDropInfo _info;
      PendingOperation _pendingOperation;
      bool _wasTouchMoveIgnored;
      Courier::TouchInfo _ignoredTouchMoveInfo;

      DDAdorner* _oldAdorner;

      hmibase::widget::adorner::Adorner::SharedPointer _adorner;
      hmibase::widget::adorner::AdornerManager* _adornerManager;
};


}
#endif//_DRAG_DROP_MANAGER_H
