/* ***************************************************************************************
* FILE:          DDAdorner.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DDAdorner is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "Widgets/2D/BaseWidget2D.h"
#include "Widgets/2D/ControlTemplate/TCloneTraverser.h"
#include "DDAdorner.h"
#include "DDManager.h"
#include "View/CGI/CgiExtensions/AppViewHandler.h"
#include <FeatStd/MemoryManagement/Disposer.h>
#include <Candera/System/Mathematics/Rectangle.h>
#include <Candera/Engine2D/Core/Node2D.h>
#include <Candera/Engine2D/Core/Group2D.h>
#include <CanderaPlatform/Device/Common/Effects/SolidColorBrushBlend.h>
#include <CanderaPlatform/Device/Common/Effects/TextBrush.h>


#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_DRAG_DROP
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/DDAdorner.cpp.trc.h"
#endif

namespace DragDrop {
DDAdorner::DDAdorner() : _visible(false), _node(NULL), _view(NULL), _touchInfo(0, 0, 0, 0, 0)
{
}


DDAdorner::~DDAdorner()
{
   if (_node != NULL)
   {
      destroy();
      _node = NULL;
   }
   _view = NULL;
}


//class DDAdornerSolidColorBrush : public Candera::SolidColorBrushBlend
//{
//      typedef Candera::SolidColorBrushBlend Base;
//   public:
//      DDAdornerSolidColorBrush() : Base() {}
//      ~DDAdornerSolidColorBrush()
//      {
//
//      }
//
//      virtual void Render(Candera::SurfaceHandle input, const Candera::Rectangle& inputArea,
//         const Candera::Matrix3x2& transform, const Candera::Node2D& node,
//         Candera::ContextHandle2D output, Candera::Rectangle& outputArea)
//      {
//         //ETG_TRACE_USR1_DCL((TR_CLASS_HMI_FW_DRAG_DROP, "DDAdornerSolidColorBrush::render() input[%.0f,%.0f,%.0f,%.0f], output[%.0f,%.0f,%.0f,%.0f]",
//         //   inputArea.GetLeft(), inputArea.GetTop(), inputArea.GetWidth(), inputArea.GetHeight(),
//         //   outputArea.GetLeft(), outputArea.GetTop(), outputArea.GetWidth(), outputArea.GetHeight()));
//
//         Base::Render(input, inputArea, transform, node, output, outputArea);
//      }
//};

class DDAdornerGroup : public Candera::Group2D
{
      typedef Candera::Group2D Base;
   public:
      DDAdornerGroup(DDAdorner* adorner) : Base(), _adorner(adorner)
      {
      }

      virtual ~DDAdornerGroup()
      {
         if (_adorner != NULL)
         {
            _adorner->onNodeDeleted(this);
            _adorner = NULL;
         }
      }

   private:
      DDAdorner* _adorner;
};


void DDAdorner::onNodeDeleted(const Candera::Node2D* node)
{
   if ((_node != NULL) && (node == _node))
   {
      ETG_TRACE_USR1_DCL((TR_CLASS_HMI_FW_DRAG_DROP, "DDAdorner::onNodeDeleted()"));
      _node = NULL;
      DDManager::getInstance().cancelOperation();
   }
}


class DDAdornerCloneTraverser  : public TCloneTraverser<Candera::Node2D>
{
      typedef TCloneTraverser<Candera::Node2D> Base;
   public:
      DDAdornerCloneTraverser() : Base() {}

   protected:
      virtual TraverserBase::TraverserAction OnClone(const Candera::Node2D& node, Candera::Node2D& nodeClone)
      {
         Candera::RenderNode* renderNode = Candera::Dynamic_Cast<Candera::RenderNode*>(&nodeClone);
         if (renderNode != NULL)
         {
            Candera::Effect2D* effect = renderNode->GetEffect(0);
            if (effect != NULL)
            {
               Candera::TextBrush* textBrush = Candera::Dynamic_Cast<Candera::TextBrush*>(effect->GetBrushEffect2D());
               if ((textBrush != NULL) && (textBrush->Text().Get() != NULL))
               {
                  FeatStd::TChar* buffer = FEATSTD_NEW_ARRAY(FeatStd::TChar, FeatStd::Internal::String::Length(textBrush->Text().Get()) + 1);
                  if (buffer != NULL)
                  {
                     FeatStd::Internal::String::Copy(buffer, textBrush->Text().Get());
                     textBrush->Text().Set(buffer, FeatStd::MemoryManagement::ArrayDisposer<const FeatStd::TChar*>::Dispose);
                  }
               }
            }
            renderNode->SetClippingRect();
         }
         return Base::OnClone(node, nodeClone);
      }

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(DDAdornerCloneTraverser);
};


void DDAdorner::create(BaseWidget2D& widget, const Courier::TouchInfo& touchInfo)
{
   ETG_TRACE_USR1_DCL((TR_CLASS_HMI_FW_DRAG_DROP, "DDAdorner::create()"));

   Candera::Node2D* node = widget.GetNode();
   if ((node != NULL) && (node->GetScene() != NULL))
   {
      if (_node != NULL)
      {
         destroy();
      }

      _node = CANDERA_NEW(DDAdornerGroup)(this);
      if (_node != NULL)
      {
         _node->SetName("DragDropAdorner");
         _node->SetPosition(node->GetWorldPosition());
         _node->SetRenderingEnabled(false);
         _node->SetRenderOrderRank(1000);

         //create a clone of the source node
         DDAdornerCloneTraverser cloneTraverser;
         cloneTraverser.Traverse(*node);
         Candera::Node2D* cloneAdorner = cloneTraverser.GetRootClone();
         if (cloneAdorner != NULL)
         {
            cloneAdorner->SetPosition(Candera::Vector2());
            _node->AddChild(cloneAdorner);
            cloneAdorner->Upload(Candera::ScopeMask(), Candera::Node2D::Deep);
         }

         //create a solid color rectangle
         //Candera::RenderNode* solidColorBrushAdorner = Candera::RenderNode::Create();
         //if (solidColorBrushAdorner != NULL)
         //{
         //   Candera::SolidColorBrushBlend* effect = CANDERA_NEW(DDAdornerSolidColorBrush);
         //   if (effect != NULL)
         //   {
         //      Candera::Rectangle nodeBounds;
         //      node->GetEffectiveBoundingRectangle(nodeBounds);
         //      effect->GetSolidColorBrush().Size().Set(nodeBounds.GetSize());
         //      effect->GetSolidColorBrush().Color().Set(Candera::Color(0.5f, 0.5f, 0.5f, 0.5f));
         //      solidColorBrushAdorner->AddEffect(effect);
         //   }
         //   _node->AddChild(solidColorBrushAdorner);
         //}

         node->GetScene()->AddChild(_node);
         _view = widget.GetParentView();
      }
   }
   _touchInfo = touchInfo;
}


void DDAdorner::destroy()
{
   if (_node != NULL)
   {
      ETG_TRACE_USR1_DCL((TR_CLASS_HMI_FW_DRAG_DROP, "DDAdorner::destroy()"));

      _node->Unload(Candera::ScopeMask(), Candera::Node2D::Deep);
      if (_node->GetParent() != NULL)
      {
         _node->GetParent()->RemoveChild(_node);
      }

      //we'll get a callback when the node is deleted
      Candera::Node2D* temp = _node;
      _node = NULL;
      temp->Dispose();
   }
   _view = NULL;
}


void DDAdorner::show()
{
   ETG_TRACE_USR1_DCL((TR_CLASS_HMI_FW_DRAG_DROP, "DDAdorner::show()"));

   if (_node != NULL)
   {
      _visible = true;
      _node->SetRenderingEnabled(true);

      if (_view != NULL)
      {
         _view->Invalidate();
      }
   }
}


void DDAdorner::move(const Courier::TouchInfo& touchInfo)
{
   if (_node != NULL)
   {
      FeatStd::Float deltaX = static_cast<FeatStd::Float>(touchInfo.mX - _touchInfo.mX);
      FeatStd::Float deltaY = static_cast<FeatStd::Float>(touchInfo.mY - _touchInfo.mY);

      if ((deltaX != 0) || (deltaY != 0))
      {
         _node->Translate(Candera::Vector2(deltaX, deltaY));

         if (_view != NULL)
         {
            _view->Invalidate();
         }
         //ETG_TRACE_USR1_DCL((TR_CLASS_HMI_FW_DRAG_DROP, "DDAdorner::move() x=%.0f, y=%.0f",
         //   _node->GetWorldPosition().GetX(), _node->GetWorldPosition().GetY()));
      }
   }

   _touchInfo = touchInfo;
}


void DDAdorner::hide()
{
   ETG_TRACE_USR1_DCL((TR_CLASS_HMI_FW_DRAG_DROP, "DDAdorner::hide()"));

   _visible = false;
   if (_node != NULL)
   {
      _node->SetRenderingEnabled(false);

      if (_view != NULL)
      {
         _view->Invalidate();
      }
   }
   destroy();
}


}
