/* ***************************************************************************************
* FILE:          DockSideWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DockSideWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(DockSideWidget2D_H)
#define DockSideWidget2D_H

#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"
#include "Widgets/2D/DockSide/generated/DockSideWidget2DBase.h"

class DockSideWidget2D : public DockSideWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(DockSideWidget2D, DockSideWidget2DBase);

      DockSideWidget2D();
      virtual ~DockSideWidget2D();

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      virtual void Update();

      CdaWidget2DDef(DockSideWidget2D, DockSideWidget2DBase)
      CdaProperties() //Start of properties
      CdaPropertiesEnd() // End of properties
      CdaWidgetDefEnd()

   protected:
      virtual void OnChanged(Courier::UInt32 /*propertyId*/);

      virtual void OnNodeChanged();

   private:
      bool _invalid;
};


#endif
